/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.test;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.exposure.client.util.Minecrft;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class Slider
extends AbstractWidget {
    public static final ResourceLocation SLIDER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider");
    public static final ResourceLocation HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_highlighted");
    public static final ResourceLocation SLIDER_HANDLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle");
    public static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/slider_handle_highlighted");
    protected static final int TEXT_MARGIN = 2;
    protected static final int HANDLE_WIDTH = 8;
    protected static final int HANDLE_HALF_WIDTH = 4;
    protected double position;
    protected boolean canChangeValue;
    protected final double defaultValue;
    protected final double min;
    protected final double max;
    protected final DecimalFormat displayFormat;
    protected final String name;
    protected final Consumer<Double> onChanged;
    @Nullable
    protected Pair<Integer, Integer> horizontalGradient;

    public Slider(int x, int y, int width, int height, double defaultValue, double min, double max, int displayedPrecision, String name, Consumer<Double> onChanged) {
        this(x, y, width, height, CommonComponents.EMPTY, defaultValue, min, max, displayedPrecision, name, onChanged);
    }

    public Slider(int x, int y, int width, int height, Component message, double defaultValue, double min, double max, int displayedPrecision, String name, Consumer<Double> onChanged) {
        super(x, y, width, height, message);
        this.position = (defaultValue - min) / (max - min);
        this.defaultValue = Mth.clamp((double)defaultValue, (double)min, (double)max);
        this.min = min;
        this.max = max;
        String zeros = "#".repeat(displayedPrecision);
        this.displayFormat = new DecimalFormat("#" + (String)(zeros.isEmpty() ? "" : "." + zeros));
        this.name = name;
        this.onChanged = onChanged;
        this.updateMessage();
    }

    public Slider setHorizontalGradient(int leftColor, int rightColor) {
        this.horizontalGradient = Pair.of((Object)leftColor, (Object)rightColor);
        return this;
    }

    public void removeHorizontalGradient() {
        this.horizontalGradient = null;
    }

    protected ResourceLocation getSprite() {
        return this.isFocused() && !this.canChangeValue ? HIGHLIGHTED_SPRITE : SLIDER_SPRITE;
    }

    protected ResourceLocation getHandleSprite() {
        return !this.isHovered && !this.canChangeValue ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double position) {
        double d = this.position;
        this.position = Mth.clamp((double)position, (double)0.0, (double)1.0);
        if (d != this.position) {
            this.applyValue();
        }
        this.updateMessage();
    }

    public Double getValue() {
        return Mth.clampedLerp((double)this.min, (double)this.max, (double)this.position);
    }

    public void setValue(double value) {
        double positionFromValue = (value - this.min) / (this.max - this.min);
        this.setPosition(positionFromValue);
    }

    public void resetToDefault() {
        this.setValue(this.defaultValue);
    }

    protected void updateMessage() {
        this.setMessage((Component)Component.literal((String)(this.name + ": " + this.displayFormat.format(this.getValue()))));
    }

    protected void applyValue() {
        this.onChanged.accept(this.getValue());
    }

    public void onClick(double mouseX, double mouseY) {
        this.setPositionFromMouse(mouseX);
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.canChangeValue = false;
        } else {
            InputType inputType = Minecraft.getInstance().getLastInputType();
            if (inputType == InputType.MOUSE || inputType == InputType.KEYBOARD_TAB) {
                this.canChangeValue = true;
            }
        }
    }

    protected void setPositionFromMouse(double mouseX) {
        this.setPosition((mouseX - (double)(this.getX() + 4)) / (double)(this.width - 8));
    }

    public void onRelease(double mouseX, double mouseY) {
        super.playDownSound(Minecraft.getInstance().getSoundManager());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && this.active && this.visible && this.clicked(mouseX, mouseY)) {
            this.resetToDefault();
            this.playDownSound(Minecrft.get().getSoundManager());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.setPositionFromMouse(mouseX);
        super.onDrag(mouseX, mouseY, dragX, dragY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (CommonInputs.selected((int)keyCode)) {
            this.canChangeValue = !this.canChangeValue;
            return true;
        }
        if (this.canChangeValue) {
            boolean bl;
            boolean bl2 = bl = keyCode == 263;
            if (bl || keyCode == 262) {
                float f = bl ? -1.0f : 1.0f;
                this.setPosition(this.position + (double)(f / (float)(this.width - 8)));
                return true;
            }
        }
        return false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(this.getSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.active && this.horizontalGradient != null) {
            this.fillHorizontalGradient(guiGraphics, this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, (Integer)this.horizontalGradient.getFirst(), (Integer)this.horizontalGradient.getSecond());
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 50.0f);
        guiGraphics.blitSprite(this.getHandleSprite(), this.getX() + (int)(this.position * (double)(this.width - 8)), this.getY(), 8, this.getHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int textColor = (this.active ? 0xFFFFFF : 0xA0A0A0) | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
        this.renderScrollingString(guiGraphics, minecraft.font, 2, textColor);
        guiGraphics.pose().popPose();
    }

    private void fillHorizontalGradient(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        VertexConsumer consumer = guiGraphics.bufferSource().getBuffer(RenderType.gui());
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        consumer.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(colorFrom);
        consumer.addVertex(matrix4f, (float)x1, (float)y2, 0.0f).setColor(colorFrom);
        consumer.addVertex(matrix4f, (float)x2, (float)y2, 0.0f).setColor(colorTo);
        consumer.addVertex(matrix4f, (float)x2, (float)y1, 0.0f).setColor(colorTo);
    }

    @NotNull
    protected MutableComponent createNarrationMessage() {
        return Component.translatable((String)"gui.narrate.slider", (Object[])new Object[]{this.getMessage()});
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.slider.usage.hovered"));
            }
        }
    }
}

