/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.camera.button;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FrameCounterButton
extends ImageButton {
    protected final int secondaryFontColor;
    protected final int mainFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_MAIN_COLOR);

    public FrameCounterButton(int x, int y, int width, int height, WidgetSprites sprites) {
        super(x, y, width, height, sprites, button -> {});
        this.secondaryFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_SECONDARY_COLOR);
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        MutableComponent tooltipComponent = Component.translatable((String)"gui.exposure.camera_controls.film_frame_counter.tooltip");
        if (!this.cameraHasFilmRoll()) {
            tooltipComponent.append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"gui.exposure.camera_controls.film_frame_counter.tooltip.no_film").withStyle(Style.EMPTY.withColor(14508887)));
        }
        this.setTooltip(Tooltip.create((Component)tooltipComponent));
        super.renderWidget(guiGraphics, mouseX, mouseY, pPartialTick);
        String text = this.createText();
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width(text);
        int xPos = 15 + (27 - textWidth) / 2;
        guiGraphics.drawString(font, text, this.getX() + xPos, this.getY() + 8, this.secondaryFontColor, false);
        guiGraphics.drawString(font, text, this.getX() + xPos, this.getY() + 7, this.mainFontColor, false);
    }

    protected String createText() {
        return Minecrft.player().getActiveExposureCameraOptional().map(camera -> {
            Item patt0$temp;
            ItemStack filmStack = Attachment.FILM.get(camera.getItemStack()).getForReading();
            if (filmStack.isEmpty() || !((patt0$temp = filmStack.getItem()) instanceof FilmRollItem)) {
                return "-";
            }
            FilmRollItem filmItem = (FilmRollItem)patt0$temp;
            int exposedFrames = filmItem.getStoredFrames(filmStack).size();
            int totalFrames = filmItem.getMaxFrameCount(filmStack);
            return exposedFrames + "/" + totalFrames;
        }).orElse("-");
    }

    protected boolean cameraHasFilmRoll() {
        return Minecrft.player().getActiveExposureCameraOptional().map(camera -> Attachment.FILM.isPresent(camera.getItemStack())).orElse(false);
    }
}

