/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancements.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.world.camera.frame.EntityInFrame;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;

public record EntityInFramePredicate(Optional<ResourceLocation> type, Optional<String> name, MinMaxBounds.Ints distance) {
    public static final Codec<EntityInFramePredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("type").forGetter(EntityInFramePredicate::type), (App)Codec.STRING.optionalFieldOf("name").forGetter(EntityInFramePredicate::name), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("distance", (Object)MinMaxBounds.Ints.ANY).forGetter(EntityInFramePredicate::distance)).apply((Applicative)instance, EntityInFramePredicate::new));

    public boolean matches(EntityInFrame entity) {
        if (this.type.isPresent() && !this.type.get().equals((Object)entity.id())) {
            return false;
        }
        if (this.name.isPresent() && !this.name.get().equals(entity.name())) {
            return false;
        }
        return this.distance().matches(entity.distance());
    }

    public boolean matches(List<EntityInFrame> entitiesInFrame) {
        return entitiesInFrame.stream().anyMatch(this::matches);
    }
}

