/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.compat;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.compat.DistantHorizonsHandler;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class DistantHorizons {
    private static boolean initialized = false;
    private static boolean dhPresent = false;
    private static DistantHorizonsHandler handler = null;
    private static final int DEFAULT_DEPTH_TEXTURE_ID = -1;
    private static final Matrix4f DEFAULT_MATRIX = new Matrix4f();
    private static final float DEFAULT_NEAR_PLANE = 0.05f;
    private static final float DEFAULT_FAR_PLANE = 1024.0f;
    private static final int DEFAULT_RENDER_DISTANCE = 256;

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            Class.forName("com.seibel.distanthorizons.api.DhApi");
            handler = new DistantHorizonsHandler();
            handler.initialize();
            dhPresent = true;
            PMWeather.LOGGER.info("Distant Horizons compatibility initialized");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            PMWeather.LOGGER.info("Distant Horizons not found, skipping integration");
            dhPresent = false;
            handler = null;
        }
        catch (Exception e) {
            PMWeather.LOGGER.error("Failed to initialize Distant Horizons compatibility", (Throwable)e);
            dhPresent = false;
            handler = null;
        }
    }

    public static boolean isAvailable() {
        return dhPresent && handler != null && handler.isReady();
    }

    public static int getDepthTextureId() {
        return DistantHorizons.isAvailable() ? handler.getDepthTextureId() : -1;
    }

    public static Matrix4f getDhProjectionMatrix() {
        return DistantHorizons.isAvailable() ? handler.getDhProjectionMatrix() : new Matrix4f((Matrix4fc)DEFAULT_MATRIX);
    }

    public static Matrix4f getDhModelViewMatrix() {
        return DistantHorizons.isAvailable() ? handler.getDhModelViewMatrix() : new Matrix4f((Matrix4fc)DEFAULT_MATRIX);
    }

    public static float getNearPlane() {
        return DistantHorizons.isAvailable() ? handler.getNearPlane() : 0.05f;
    }

    public static float getFarPlane() {
        return DistantHorizons.isAvailable() ? handler.getFarPlane() : 1024.0f;
    }

    public static int getChunkRenderDistance() {
        return DistantHorizons.isAvailable() ? handler.getChunkRenderDistance() : 256;
    }
}

