/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.registries;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import mekanism.additions.common.block.BlockGlowPanel;
import mekanism.additions.common.block.BlockObsidianTNT;
import mekanism.additions.common.block.plastic.BlockPlastic;
import mekanism.additions.common.block.plastic.BlockPlasticFence;
import mekanism.additions.common.block.plastic.BlockPlasticFenceGate;
import mekanism.additions.common.block.plastic.BlockPlasticRoad;
import mekanism.additions.common.block.plastic.BlockPlasticSlab;
import mekanism.additions.common.block.plastic.BlockPlasticStairs;
import mekanism.additions.common.block.plastic.BlockPlasticTransparent;
import mekanism.additions.common.block.plastic.BlockPlasticTransparentSlab;
import mekanism.additions.common.block.plastic.BlockPlasticTransparentStairs;
import mekanism.api.text.EnumColor;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.item.block.ItemBlockMekanism;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.Holder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class AdditionsBlocks {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister("mekanismadditions");
    public static final BlockRegistryObject<BlockObsidianTNT, BlockItem> OBSIDIAN_TNT = BLOCKS.register("obsidian_tnt", BlockObsidianTNT::new);
    public static final Map<EnumColor, BlockRegistryObject<BlockGlowPanel, ItemBlockMekanism<BlockGlowPanel>>> GLOW_PANELS = new EnumMap<EnumColor, BlockRegistryObject<BlockGlowPanel, ItemBlockMekanism<BlockGlowPanel>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>>> PLASTIC_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>>> SLICK_PLASTIC_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>>> PLASTIC_GLOW_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>>> REINFORCED_PLASTIC_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticRoad, ItemBlockMekanism<BlockPlasticRoad>>> PLASTIC_ROADS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticRoad, ItemBlockMekanism<BlockPlasticRoad>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticTransparent, ItemBlockMekanism<BlockPlasticTransparent>>> TRANSPARENT_PLASTIC_BLOCKS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticTransparent, ItemBlockMekanism<BlockPlasticTransparent>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticStairs, ItemBlockMekanism<BlockPlasticStairs>>> PLASTIC_STAIRS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticStairs, ItemBlockMekanism<BlockPlasticStairs>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticSlab, ItemBlockMekanism<BlockPlasticSlab>>> PLASTIC_SLABS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticSlab, ItemBlockMekanism<BlockPlasticSlab>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticFence, ItemBlockMekanism<BlockPlasticFence>>> PLASTIC_FENCES = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticFence, ItemBlockMekanism<BlockPlasticFence>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticFenceGate, ItemBlockMekanism<BlockPlasticFenceGate>>> PLASTIC_FENCE_GATES = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticFenceGate, ItemBlockMekanism<BlockPlasticFenceGate>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticStairs, ItemBlockMekanism<BlockPlasticStairs>>> PLASTIC_GLOW_STAIRS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticStairs, ItemBlockMekanism<BlockPlasticStairs>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticSlab, ItemBlockMekanism<BlockPlasticSlab>>> PLASTIC_GLOW_SLABS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticSlab, ItemBlockMekanism<BlockPlasticSlab>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticTransparentStairs, ItemBlockMekanism<BlockPlasticTransparentStairs>>> TRANSPARENT_PLASTIC_STAIRS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticTransparentStairs, ItemBlockMekanism<BlockPlasticTransparentStairs>>>(EnumColor.class);
    public static final Map<EnumColor, BlockRegistryObject<BlockPlasticTransparentSlab, ItemBlockMekanism<BlockPlasticTransparentSlab>>> TRANSPARENT_PLASTIC_SLABS = new EnumMap<EnumColor, BlockRegistryObject<BlockPlasticTransparentSlab, ItemBlockMekanism<BlockPlasticTransparentSlab>>>(EnumColor.class);

    private AdditionsBlocks() {
    }

    private static BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>> registerPlastic(EnumColor color, String blockTypeSuffix, UnaryOperator<BlockBehaviour.Properties> propertyModifier) {
        return AdditionsBlocks.registerColoredBlock(c -> new BlockPlastic((EnumColor)c, propertyModifier), blockTypeSuffix, color);
    }

    private static BlockRegistryObject<BlockPlasticSlab, ItemBlockMekanism<BlockPlasticSlab>> registerPlasticSlab(EnumColor color, String blockTypeSuffix, UnaryOperator<BlockBehaviour.Properties> propertyModifier) {
        return AdditionsBlocks.registerColoredBlock(c -> new BlockPlasticSlab((EnumColor)c, propertyModifier), blockTypeSuffix, color);
    }

    private static BlockRegistryObject<BlockPlasticStairs, ItemBlockMekanism<BlockPlasticStairs>> registerPlasticStairs(Holder<Block> baseBlock, EnumColor color, String blockTypeSuffix, UnaryOperator<BlockBehaviour.Properties> propertyModifier) {
        return AdditionsBlocks.registerColoredBlock(c -> new BlockPlasticStairs(((Block)baseBlock.value()).defaultBlockState(), (EnumColor)c, propertyModifier), blockTypeSuffix, color);
    }

    private static <BLOCK extends Block> BlockRegistryObject<BLOCK, ItemBlockMekanism<BLOCK>> registerColoredBlock(Function<EnumColor, BLOCK> blockCreator, String blockTypeSuffix, EnumColor color) {
        return BLOCKS.register(color.getRegistryPrefix() + blockTypeSuffix, () -> (Block)blockCreator.apply(color), (x$0, x$1) -> new ItemBlockMekanism((Block)x$0, x$1));
    }

    static {
        for (EnumColor color : EnumUtils.COLORS) {
            GLOW_PANELS.put(color, AdditionsBlocks.registerColoredBlock(BlockGlowPanel::new, "_glow_panel", color));
            BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>> plasticBlockRO = AdditionsBlocks.registerPlastic(color, "_plastic", properties -> properties.strength(5.0f, 6.0f));
            PLASTIC_BLOCKS.put(color, plasticBlockRO);
            SLICK_PLASTIC_BLOCKS.put(color, AdditionsBlocks.registerPlastic(color, "_slick_plastic", properties -> properties.strength(5.0f, 6.0f).friction(0.98f)));
            BlockRegistryObject<BlockPlastic, ItemBlockMekanism<BlockPlastic>> plasticGlowBlockRO = AdditionsBlocks.registerPlastic(color, "_plastic_glow", properties -> properties.strength(5.0f, 6.0f).lightLevel(state -> 10).emissiveRendering(BlockStateHelper.ALWAYS_PREDICATE));
            PLASTIC_GLOW_BLOCKS.put(color, plasticGlowBlockRO);
            REINFORCED_PLASTIC_BLOCKS.put(color, AdditionsBlocks.registerPlastic(color, "_reinforced_plastic", properties -> properties.strength(50.0f, 1200.0f)));
            PLASTIC_ROADS.put(color, AdditionsBlocks.registerColoredBlock(BlockPlasticRoad::new, "_plastic_road", color));
            BlockRegistryObject<BlockPlasticTransparent, ItemBlockMekanism<BlockPlasticTransparent>> transparentPlasticRO = AdditionsBlocks.registerColoredBlock(BlockPlasticTransparent::new, "_plastic_transparent", color);
            TRANSPARENT_PLASTIC_BLOCKS.put(color, transparentPlasticRO);
            PLASTIC_STAIRS.put(color, AdditionsBlocks.registerPlasticStairs(plasticBlockRO, color, "_plastic_stairs", UnaryOperator.identity()));
            PLASTIC_SLABS.put(color, AdditionsBlocks.registerPlasticSlab(color, "_plastic_slab", UnaryOperator.identity()));
            PLASTIC_FENCES.put(color, AdditionsBlocks.registerColoredBlock(BlockPlasticFence::new, "_plastic_fence", color));
            PLASTIC_FENCE_GATES.put(color, AdditionsBlocks.registerColoredBlock(BlockPlasticFenceGate::new, "_plastic_fence_gate", color));
            PLASTIC_GLOW_STAIRS.put(color, AdditionsBlocks.registerPlasticStairs(plasticGlowBlockRO, color, "_plastic_glow_stairs", properties -> properties.lightLevel(state -> 10).emissiveRendering(BlockStateHelper.ALWAYS_PREDICATE)));
            PLASTIC_GLOW_SLABS.put(color, AdditionsBlocks.registerPlasticSlab(color, "_plastic_glow_slab", properties -> properties.lightLevel(state -> 10).emissiveRendering(BlockStateHelper.ALWAYS_PREDICATE)));
            TRANSPARENT_PLASTIC_STAIRS.put(color, AdditionsBlocks.registerColoredBlock(c -> new BlockPlasticTransparentStairs(transparentPlasticRO.defaultState(), (EnumColor)c), "_plastic_transparent_stairs", color));
            TRANSPARENT_PLASTIC_SLABS.put(color, AdditionsBlocks.registerColoredBlock(BlockPlasticTransparentSlab::new, "_plastic_transparent_slab", color));
        }
    }
}

