/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import mekanism.additions.common.AdditionsLang;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.registries.AdditionsDataComponents;
import mekanism.api.text.EnumColor;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemWalkieTalkie
extends Item
implements IModeItem {
    public ItemWalkieTalkie(Item.Properties properties) {
        super(properties.stacksTo(1).component(AdditionsDataComponents.WALKIE_DATA, (Object)WalkieData.DEFAULT));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        WalkieData data = (WalkieData)stack.getOrDefault(AdditionsDataComponents.WALKIE_DATA, (Object)WalkieData.DEFAULT);
        tooltip.add(BooleanStateDisplay.OnOff.of((boolean)data.running(), (boolean)true).getTextComponent());
        tooltip.add((Component)AdditionsLang.CHANNEL.translateColored(EnumColor.DARK_AQUA, new Object[]{EnumColor.GRAY, data.channel()}));
        if (!MekanismAdditionsConfig.additions.voiceServerEnabled.get()) {
            tooltip.add((Component)AdditionsLang.WALKIE_DISABLED.translateColored(EnumColor.DARK_RED));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            WalkieData data = (WalkieData)stack.getOrDefault(AdditionsDataComponents.WALKIE_DATA, (Object)WalkieData.DEFAULT);
            stack.set(AdditionsDataComponents.WALKIE_DATA, (Object)new WalkieData(data.channel(), !data.running()));
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.getItem() != newStack.getItem();
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        WalkieData data = (WalkieData)stack.getOrDefault(AdditionsDataComponents.WALKIE_DATA, (Object)WalkieData.DEFAULT);
        if (data.running()) {
            int newChannel = Math.floorMod(data.channel() + shift - 1, 8) + 1;
            if (data.channel() != newChannel) {
                stack.set(AdditionsDataComponents.WALKIE_DATA, (Object)new WalkieData(newChannel, true));
                displayChange.sendMessage(player, (Object)newChannel, xva$0 -> AdditionsLang.CHANNEL_CHANGE.translate(new Object[]{xva$0}));
            }
        }
    }

    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        WalkieData data = (WalkieData)stack.getOrDefault(AdditionsDataComponents.WALKIE_DATA, (Object)WalkieData.DEFAULT);
        return AdditionsLang.CHANNEL.translateColored(EnumColor.GRAY, new Object[]{EnumColor.WHITE, data.channel()});
    }

    public record WalkieData(int channel, boolean running) {
        public static final WalkieData DEFAULT = new WalkieData(1, false);
        public static final Codec<WalkieData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.intRange((int)1, (int)8).fieldOf("channel").forGetter(WalkieData::channel), (App)Codec.BOOL.fieldOf("running").forGetter(WalkieData::running)).apply((Applicative)instance, WalkieData::new));
        public static final StreamCodec<ByteBuf, WalkieData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, WalkieData::channel, (StreamCodec)ByteBufCodecs.BOOL, WalkieData::running, WalkieData::new);
    }
}

