/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.client;

import java.util.Map;
import mekanism.additions.client.AdditionsKeyHandler;
import mekanism.additions.client.model.AdditionsModelCache;
import mekanism.additions.client.model.ModelBabyCreeper;
import mekanism.additions.client.render.entity.RenderBabyCreeper;
import mekanism.additions.client.render.entity.RenderBabyEnderman;
import mekanism.additions.client.render.entity.RenderBalloon;
import mekanism.additions.common.MekanismAdditions;
import mekanism.additions.common.item.ItemBalloon;
import mekanism.additions.common.item.ItemWalkieTalkie;
import mekanism.additions.common.registries.AdditionsBlocks;
import mekanism.additions.common.registries.AdditionsDataComponents;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.additions.common.registries.AdditionsItems;
import mekanism.api.text.EnumColor;
import mekanism.client.ClientRegistrationUtil;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.ItemRegistryObject;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.entity.BoggedRenderer;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.StrayRenderer;
import net.minecraft.client.renderer.entity.TntRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(modid="mekanismadditions", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class AdditionsClientRegistration {
    private AdditionsClientRegistration() {
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ClientRegistrationUtil.setPropertyOverride(AdditionsItems.WALKIE_TALKIE, (ResourceLocation)MekanismAdditions.rl("channel"), (stack, world, entity, seed) -> {
            ItemWalkieTalkie.WalkieData data = (ItemWalkieTalkie.WalkieData)stack.getOrDefault(AdditionsDataComponents.WALKIE_DATA, (Object)ItemWalkieTalkie.WalkieData.DEFAULT);
            return data.running() ? (float)data.channel() : 0.0f;
        }));
    }

    @SubscribeEvent
    public static void registerKeybindings(RegisterKeyMappingsEvent event) {
        AdditionsKeyHandler.registerKeybindings(event);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AdditionsEntityTypes.OBSIDIAN_TNT.get(), TntRenderer::new);
        event.registerEntityRenderer((EntityType)AdditionsEntityTypes.BALLOON.get(), RenderBalloon::new);
        event.registerEntityRenderer((EntityType)AdditionsEntityTypes.BABY_BOGGED.get(), BoggedRenderer::new);
        event.registerEntityRenderer((EntityType)AdditionsEntityTypes.BABY_CREEPER.get(), RenderBabyCreeper::new);
        event.registerEntityRenderer((EntityType)AdditionsEntityTypes.BABY_ENDERMAN.get(), RenderBabyEnderman::new);
        event.registerEntityRenderer((EntityType)AdditionsEntityTypes.BABY_SKELETON.get(), SkeletonRenderer::new);
        event.registerEntityRenderer((EntityType)AdditionsEntityTypes.BABY_STRAY.get(), StrayRenderer::new);
        event.registerEntityRenderer((EntityType)AdditionsEntityTypes.BABY_WITHER_SKELETON.get(), WitherSkeletonRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModelBabyCreeper.CREEPER_LAYER, () -> ModelBabyCreeper.createBodyLayer(CubeDeformation.NONE));
        event.registerLayerDefinition(ModelBabyCreeper.ARMOR_LAYER, () -> ModelBabyCreeper.createBodyLayer(new CubeDeformation(1.0f)));
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        ClientRegistrationUtil.registerBlockExtensions((RegisterClientExtensionsEvent)event, (BlockDeferredRegister)AdditionsBlocks.BLOCKS);
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        AdditionsModelCache.INSTANCE.setup(event);
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.BakingCompleted event) {
        AdditionsModelCache.INSTANCE.onBake(event);
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        AdditionsClientRegistration.registerIColoredBlocks((RegisterColorHandlersEvent)event);
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        AdditionsClientRegistration.registerIColoredBlocks((RegisterColorHandlersEvent)event);
        ItemColor balloonColorHandler = (stack, tintIndex) -> {
            int n;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof ItemBalloon) {
                ItemBalloon balloon = (ItemBalloon)patt0$temp;
                n = balloon.getColor().getPackedColor();
            } else {
                n = -1;
            }
            return n;
        };
        for (ItemRegistryObject<ItemBalloon> balloon : AdditionsItems.BALLOONS.values()) {
            ClientRegistrationUtil.registerItemColorHandler((RegisterColorHandlersEvent.Item)event, (ItemColor)balloonColorHandler, (ItemLike[])new ItemLike[]{balloon});
        }
    }

    private static void registerIColoredBlocks(RegisterColorHandlersEvent event) {
        AdditionsClientRegistration.registerBlockColorHandles(event, AdditionsBlocks.GLOW_PANELS, AdditionsBlocks.PLASTIC_BLOCKS, AdditionsBlocks.SLICK_PLASTIC_BLOCKS, AdditionsBlocks.PLASTIC_GLOW_BLOCKS, AdditionsBlocks.REINFORCED_PLASTIC_BLOCKS, AdditionsBlocks.PLASTIC_ROADS, AdditionsBlocks.TRANSPARENT_PLASTIC_BLOCKS, AdditionsBlocks.PLASTIC_STAIRS, AdditionsBlocks.PLASTIC_SLABS, AdditionsBlocks.PLASTIC_FENCES, AdditionsBlocks.PLASTIC_FENCE_GATES, AdditionsBlocks.PLASTIC_GLOW_STAIRS, AdditionsBlocks.PLASTIC_GLOW_SLABS, AdditionsBlocks.TRANSPARENT_PLASTIC_STAIRS, AdditionsBlocks.TRANSPARENT_PLASTIC_SLABS);
    }

    @SafeVarargs
    private static void registerBlockColorHandles(RegisterColorHandlersEvent event, Map<EnumColor, ? extends BlockRegistryObject<?, ?>> ... blocks) {
        for (Map<EnumColor, BlockRegistryObject<?, ?>> map : blocks) {
            for (BlockRegistryObject<?, ?> block : map.values()) {
                ClientRegistrationUtil.registerIColoredBlockHandler((RegisterColorHandlersEvent)event, (BlockRegistryObject[])new BlockRegistryObject[]{block});
            }
        }
    }
}

