/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.packets;

import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AdventureUtil;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class BlockEntityBehaviourConfigurationPacket<B extends BlockEntityBehaviour>
implements ServerboundPacketPayload {
    protected BlockPos pos;

    public BlockEntityBehaviourConfigurationPacket(BlockPos pos) {
        this.pos = pos;
    }

    protected abstract BehaviourType<B> getType();

    public void handle(ServerPlayer player) {
        if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
            return;
        }
        Level world = player.level();
        if (!world.isLoaded(this.pos)) {
            return;
        }
        if (!this.pos.closerThan((Vec3i)player.blockPosition(), (double)this.maxRange())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(this.pos);
        if (blockEntity instanceof SyncedBlockEntity) {
            Trusted trusted;
            SyncedBlockEntity sbe = (SyncedBlockEntity)blockEntity;
            if (blockEntity instanceof Trusted && !(trusted = (Trusted)blockEntity).isTrusted((Player)player)) {
                Numismatics.LOGGER.error("Illegal configuration of {} at {} attempted by player {}", new Object[]{blockEntity, this.pos, player});
                player.connection.disconnect((Component)Component.literal((String)"Haxx: Illegal block entity configuration attempt"));
                return;
            }
            BlockEntityBehaviour behaviour = BlockEntityBehaviour.get((BlockEntity)sbe, this.getType());
            this.applySettings(player, behaviour);
            if (!this.causeUpdate()) {
                return;
            }
            sbe.sendData();
            blockEntity.setChanged();
        }
    }

    protected int maxRange() {
        return 20;
    }

    protected boolean causeUpdate() {
        return true;
    }

    protected abstract void applySettings(ServerPlayer var1, B var2);
}

