/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BankAccountBehaviour;
import dev.ithundxr.createnumismatics.registry.commands.arguments.EnumArgument;
import java.util.Collection;
import java.util.UUID;
import net.createmod.catnip.data.Couple;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;

public class ViewCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"view").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"banker").then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> {
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos");
            BankAccountBehaviour bankAct = (BankAccountBehaviour)BlockEntityBehaviour.get((BlockGetter)((CommandSourceStack)ctx.getSource()).getLevel(), (BlockPos)pos, BankAccountBehaviour.TYPE);
            if (bankAct == null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("There is no Blaze Banker at " + pos.toShortString())));
                return -1;
            }
            UUID id = bankAct.getAccountUUID();
            return ViewCommand.execute((CommandContext<CommandSourceStack>)ctx, id, BankAccount.Type.BLAZE_BANKER, false, "Blaze Banker at (" + pos.toShortString() + ")");
        })).then(Commands.argument((String)"coin", EnumArgument.enumArgument(Coin.class)).executes(ctx -> {
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos");
            Coin coin = (Coin)((Object)((Object)ctx.getArgument("coin", Coin.class)));
            BankAccountBehaviour bankAct = (BankAccountBehaviour)BlockEntityBehaviour.get((BlockGetter)((CommandSourceStack)ctx.getSource()).getLevel(), (BlockPos)pos, BankAccountBehaviour.TYPE);
            if (bankAct == null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("There is no Blaze Banker at " + pos.toShortString())));
                return -1;
            }
            UUID id = bankAct.getAccountUUID();
            return ViewCommand.execute((CommandContext<CommandSourceStack>)ctx, id, BankAccount.Type.BLAZE_BANKER, false, "Blaze Banker at (" + pos.toShortString() + ")", coin);
        }))))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> {
            Collection accounts = GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player");
            int sum = 0;
            for (GameProfile account : accounts) {
                sum += ViewCommand.execute((CommandContext<CommandSourceStack>)ctx, account.getId(), BankAccount.Type.PLAYER, true, account.getName());
            }
            return sum;
        })).then(Commands.argument((String)"coin", EnumArgument.enumArgument(Coin.class)).executes(ctx -> {
            Collection accounts = GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player");
            Coin coin = (Coin)((Object)((Object)ctx.getArgument("coin", Coin.class)));
            int sum = 0;
            for (GameProfile account : accounts) {
                sum += ViewCommand.execute((CommandContext<CommandSourceStack>)ctx, account.getId(), BankAccount.Type.PLAYER, true, account.getName(), coin);
            }
            return sum;
        })));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, UUID account, BankAccount.Type type, boolean create, String name) {
        return ViewCommand.execute(ctx, account, type, create, name, Coin.SPUR);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, UUID account, BankAccount.Type type, boolean create, String name, Coin coin) {
        int balance = ViewCommand.getBalance(account, create, type);
        if (balance != -1) {
            Couple<Integer> coinAndRemainder = coin.convert(balance);
            int coinCount = (Integer)coinAndRemainder.getFirst();
            int remainder = (Integer)coinAndRemainder.getSecond();
            if (remainder == 0) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(name + " has " + coinCount + " " + coin.getName(coinCount) + ".")), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(name + " has " + coinCount + " " + coin.getName(coinCount) + " and " + remainder + " " + Coin.SPUR.getName(remainder) + ".")), true);
            }
            return coinCount;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Could not find account for " + name + ".")));
        return -1;
    }

    private static int getBalance(UUID id, boolean create, BankAccount.Type type) {
        BankAccount account;
        BankAccount bankAccount = account = create ? Numismatics.BANK.getOrCreateAccount(id, type) : Numismatics.BANK.getAccount(id);
        if (account == null) {
            return -1;
        }
        return account.getBalance();
    }
}

