/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.registry.advancement.NumismaticsAdvancement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class NumismaticsAdvancements
implements DataProvider {
    public static final List<NumismaticsAdvancement> ENTRIES = new ArrayList<NumismaticsAdvancement>();
    public static final NumismaticsAdvancement START = null;
    public static final NumismaticsAdvancement ROOT = NumismaticsAdvancements.create("root", b -> b.icon(Coin.CROWN.asStack()).title("Welcome to Numismatics").description("Here Be Riches").awardedForFree().special(NumismaticsAdvancement.TaskType.SILENT));
    public static final NumismaticsAdvancement MONEY_LAUNDERING = NumismaticsAdvancements.create("money_laundering", b -> b.icon((ItemLike)Items.WATER_BUCKET).title("Money Laundering").description("Buy coins in a vendor").after(ROOT).special(NumismaticsAdvancement.TaskType.SECRET));
    public static final NumismaticsAdvancement QUESTIONABLE_INVESTMENT = NumismaticsAdvancements.create("questionable_investment", b -> b.icon(Coin.SPUR.asStack()).title("Questionable Investment").description("Buy coins for more than they are worth").after(MONEY_LAUNDERING).special(NumismaticsAdvancement.TaskType.SECRET));
    public static final NumismaticsAdvancement IS_THIS_LEGAL = NumismaticsAdvancements.create("is_this_legal", b -> b.icon(Coin.SUN.asStack()).title("Is This Legal?").description("Buy coins for less than they are worth").after(MONEY_LAUNDERING).special(NumismaticsAdvancement.TaskType.SECRET));
    public static final NumismaticsAdvancement END = null;
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    private static NumismaticsAdvancement create(String id, UnaryOperator<NumismaticsAdvancement.Builder> b) {
        return new NumismaticsAdvancement(id, b);
    }

    public NumismaticsAdvancements(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.registries = registries;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(provider -> {
            PackOutput.PathProvider pathProvider = this.output.createPathProvider(PackOutput.Target.DATA_PACK, "advancement");
            ArrayList futures = new ArrayList();
            HashSet set = Sets.newHashSet();
            Consumer<AdvancementHolder> consumer = advancement -> {
                ResourceLocation id = advancement.id();
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate advancement " + String.valueOf(id));
                }
                Path path = pathProvider.json(id);
                LOGGER.info("Saving advancement {}", (Object)id);
                futures.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, (Codec)Advancement.CODEC, (Object)advancement.value(), (Path)path));
            };
            for (NumismaticsAdvancement advancement2 : ENTRIES) {
                advancement2.save(consumer);
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Numismatics' Advancements";
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (NumismaticsAdvancement advancement : ENTRIES) {
            advancement.provideLang(consumer);
        }
    }

    public static void register() {
    }
}

