/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.vendor;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import dev.ithundxr.createnumismatics.base.block.NotifyFailedBreak;
import dev.ithundxr.createnumismatics.content.backend.TrustedBlock;
import dev.ithundxr.createnumismatics.content.vendor.VendorBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlockEntities;
import dev.ithundxr.createnumismatics.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VendorBlock
extends Block
implements IBE<VendorBlockEntity>,
TrustedBlock,
IWrenchable,
NotifyFailedBreak {
    VoxelShape voxelShape = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)18.0, (double)15.0));
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public final boolean isCreativeVendor;

    public VendorBlock(BlockBehaviour.Properties properties, boolean isCreativeVendor) {
        super(properties);
        this.isCreativeVendor = isCreativeVendor;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING});
    }

    public Class<VendorBlockEntity> getBlockEntityClass() {
        return VendorBlockEntity.class;
    }

    public BlockEntityType<? extends VendorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NumismaticsBlockEntities.VENDOR.get();
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof VendorBlockEntity) {
                VendorBlockEntity vendorBlockEntity = (VendorBlockEntity)blockEntity;
                vendorBlockEntity.owner = player.getUUID();
            }
        }
    }

    @Override
    public void notifyFailedBreak(LevelAccessor level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof VendorBlockEntity) {
            VendorBlockEntity vendorBlockEntity = (VendorBlockEntity)blockEntity;
            vendorBlockEntity.notifyDelayedDataSync();
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof VendorBlockEntity) {
            VendorBlockEntity vbe = (VendorBlockEntity)blockEntity;
            vbe.dropContents(level, pos);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (!this.isTrusted(context.getPlayer(), (BlockGetter)context.getLevel(), context.getClickedPos())) {
            return InteractionResult.FAIL;
        }
        return super.onSneakWrenched(state, context);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isCrouching()) {
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (this.isTrusted(player, (BlockGetter)level, pos)) {
                this.withBlockEntityDo((BlockGetter)level, pos, be -> Utils.openScreen((ServerPlayer)player, be, arg_0 -> ((VendorBlockEntity)be).sendToMenu(arg_0)));
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> be.tryTransaction(player, hand));
        return ItemInteractionResult.CONSUME;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        if (!this.isTrusted(player, level, pos)) {
            return 0.0f;
        }
        return super.getDestroyProgress(state, player, level, pos);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.voxelShape;
    }
}

