/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardSlot;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.SlotDiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.depositor.AndesiteDepositorBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class AndesiteDepositorMenu
extends MenuBase<AndesiteDepositorBlockEntity> {
    public static final int COIN_SLOTS;
    public static final int CARD_SLOT_INDEX;
    public static final int PLAYER_INV_START_INDEX;
    public static final int PLAYER_HOTBAR_END_INDEX;
    public static final int PLAYER_INV_END_INDEX;

    public AndesiteDepositorMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public AndesiteDepositorMenu(MenuType<?> type, int id, Inventory inv, AndesiteDepositorBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    protected AndesiteDepositorBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof AndesiteDepositorBlockEntity) {
            AndesiteDepositorBlockEntity andesiteDepositorBE = (AndesiteDepositorBlockEntity)blockEntity;
            andesiteDepositorBE.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return andesiteDepositorBE;
        }
        return null;
    }

    protected void initAndReadInventory(AndesiteDepositorBlockEntity contentHolder) {
    }

    protected void addSlots() {
        int x = 11;
        int y = 56;
        for (Coin coin : Coin.values()) {
            this.addSlot(new SlotDiscreteCoinBag(((AndesiteDepositorBlockEntity)this.contentHolder).inventory, coin, x += 18, y, true, true));
        }
        this.addSlot(new CardSlot.BoundCardSlot(((AndesiteDepositorBlockEntity)this.contentHolder).cardContainer, 0, 11, y));
        this.addPlayerSlots(31, 99);
    }

    protected void saveData(AndesiteDepositorBlockEntity contentHolder) {
    }

    public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        super.clicked(slotId, button, clickType, player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot clickedSlot = this.getSlot(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = clickedSlot.getItem();
        if (index < COIN_SLOTS) {
            Item item = stack.getItem();
            if (!(item instanceof CoinItem)) {
                return ItemStack.EMPTY;
            }
            CoinItem coinItem = (CoinItem)item;
            Coin coin = coinItem.coin;
            int startCount = stack.getCount();
            this.moveItemStackTo(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false);
            int diff = startCount - stack.getCount();
            if (diff > 0) {
                ((AndesiteDepositorBlockEntity)this.contentHolder).inventory.subtract(coin, diff);
                clickedSlot.setChanged();
            } else if (diff < 0) {
                ((AndesiteDepositorBlockEntity)this.contentHolder).inventory.add(coin, -diff);
                clickedSlot.setChanged();
            }
            return ItemStack.EMPTY;
        }
        if (index == CARD_SLOT_INDEX) {
            if (!this.moveItemStackTo(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            if (stack.getItem() instanceof CoinItem && !this.moveItemStackTo(stack, 0, COIN_SLOTS, false)) {
                return ItemStack.EMPTY;
            }
            if (NumismaticsTags.AllItemTags.CARDS.matches(stack) && !this.moveItemStackTo(stack, CARD_SLOT_INDEX, CARD_SLOT_INDEX + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= PLAYER_INV_START_INDEX && index < PLAYER_HOTBAR_END_INDEX && !this.moveItemStackTo(stack, PLAYER_HOTBAR_END_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= PLAYER_HOTBAR_END_INDEX && index < PLAYER_INV_END_INDEX && !this.moveItemStackTo(stack, PLAYER_INV_START_INDEX, PLAYER_HOTBAR_END_INDEX, false)) {
                return ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    static {
        CARD_SLOT_INDEX = COIN_SLOTS = Coin.values().length;
        PLAYER_INV_START_INDEX = CARD_SLOT_INDEX + 1;
        PLAYER_HOTBAR_END_INDEX = PLAYER_INV_START_INDEX + 9;
        PLAYER_INV_END_INDEX = PLAYER_INV_START_INDEX + 36;
    }
}

