/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsPartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class BlazeBankerRenderer
extends SafeBlockEntityRenderer<BlazeBankerBlockEntity> {
    public BlazeBankerRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(BlazeBankerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        Level level = be.getLevel();
        BlockState blockState = be.getBlockState();
        float animation = be.headAnimation.getValue(partialTicks) * 0.175f;
        float horizontalAngle = AngleHelper.rad((double)be.headAngle.getValue(partialTicks));
        int hashCode = be.hashCode();
        BlazeBankerRenderer.renderShared(ms, bufferSource, level, blockState, animation, horizontalAngle, hashCode);
    }

    private static void renderShared(PoseStack ms, MultiBufferSource bufferSource, Level level, BlockState blockState, float animation, float horizontalAngle, int hashCode) {
        boolean blockAbove = animation > 0.125f;
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = BlazeBurnerBlock.HeatLevel.KINDLED.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = Mth.sin((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = Mth.sin((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = Mth.sin((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        float headY = offset - animation * 0.75f;
        ms.pushPose();
        if (blockAbove) {
            SpriteShiftEntry spriteShift = AllSpriteShifts.BURNER_FLAME;
            float spriteWidth = spriteShift.getTarget().getU1() - spriteShift.getTarget().getU0();
            float spriteHeight = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
            float speed = 0.03125f + 0.015625f * (float)BlazeBurnerBlock.HeatLevel.KINDLED.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            SuperByteBuffer flameBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.BLAZE_BURNER_FLAME, (BlockState)blockState);
            flameBuffer.shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll);
            BlazeBankerRenderer.draw(flameBuffer, horizontalAngle, ms, bufferSource.getBuffer(RenderType.cutoutMipped()));
        }
        PartialModel blazeModel = blockAbove ? AllPartialModels.BLAZE_ACTIVE : AllPartialModels.BLAZE_IDLE;
        SuperByteBuffer blazeBuffer = CachedBuffers.partial((PartialModel)blazeModel, (BlockState)blockState);
        blazeBuffer.translate(0.0f, headY, 0.0f);
        BlazeBankerRenderer.draw(blazeBuffer, horizontalAngle, ms, bufferSource.getBuffer(RenderType.solid()));
        SuperByteBuffer hatBuffer = CachedBuffers.partial((PartialModel)NumismaticsPartialModels.TOP_HAT, (BlockState)blockState);
        hatBuffer.translate(0.0f, headY, 0.0f);
        hatBuffer.translateY(0.75f);
        ((SuperByteBuffer)((SuperByteBuffer)hatBuffer.rotateCentered(horizontalAngle + (float)Math.PI, Direction.UP)).translate(0.5f, 0.0f, 0.5f)).light(0xF000F0).renderInto(ms, bufferSource.getBuffer(RenderType.solid()));
        PartialModel rodsModel = AllPartialModels.BLAZE_BURNER_RODS;
        PartialModel rodsModel2 = AllPartialModels.BLAZE_BURNER_RODS_2;
        SuperByteBuffer rodsBuffer = CachedBuffers.partial((PartialModel)rodsModel, (BlockState)blockState);
        ((SuperByteBuffer)rodsBuffer.translate(0.0f, offset1 + animation + 0.125f, 0.0f)).light(0xF000F0).renderInto(ms, bufferSource.getBuffer(RenderType.solid()));
        SuperByteBuffer rodsBuffer2 = CachedBuffers.partial((PartialModel)rodsModel2, (BlockState)blockState);
        ((SuperByteBuffer)rodsBuffer2.translate(0.0f, offset2 + animation - 0.1875f, 0.0f)).light(0xF000F0).renderInto(ms, bufferSource.getBuffer(RenderType.solid()));
        ms.popPose();
    }

    private static void draw(SuperByteBuffer buffer, float horizontalAngle, PoseStack ms, VertexConsumer vc) {
        ((SuperByteBuffer)buffer.rotateCentered(horizontalAngle, Direction.UP)).light(0xF000F0).renderInto(ms, vc);
    }
}

