/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.bank.CardSlot;
import dev.ithundxr.createnumismatics.content.bank.IDCardItem;
import dev.ithundxr.createnumismatics.content.bank.IDCardSlot;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerBlockEntity;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BlazeBankerMenu
extends MenuBase<BlazeBankerBlockEntity> {
    public static final int ID_CARD_SLOTS = 27;
    public static final int CARD_SLOT_INDEX = 27;
    public static final int PLAYER_INV_START_INDEX = 28;
    public static final int PLAYER_HOTBAR_END_INDEX = 37;
    public static final int PLAYER_INV_END_INDEX = 64;
    private CardWritingContainer cardWritingContainer;

    public BlazeBankerMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    protected BlazeBankerMenu(MenuType<?> type, int id, Inventory inv, BlazeBankerBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    protected BlazeBankerBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof BlazeBankerBlockEntity) {
            BlazeBankerBlockEntity blazeBankerBE = (BlazeBankerBlockEntity)blockEntity;
            blazeBankerBE.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return blazeBankerBE;
        }
        return null;
    }

    protected void initAndReadInventory(BlazeBankerBlockEntity contentHolder) {
    }

    protected void addSlots() {
        if (this.cardWritingContainer == null) {
            this.cardWritingContainer = new CardWritingContainer(arg_0 -> ((BlazeBankerMenu)this).slotsChanged(arg_0), ((BlazeBankerBlockEntity)this.contentHolder).getAccountId());
        }
        int x = 16;
        int y = 21;
        for (int i = 0; i < 27; ++i) {
            if (i % 9 == 0 && i > 0) {
                x = 16;
                y += 18;
            }
            this.addSlot(new IDCardSlot.BoundIDCardSlot(((BlazeBankerBlockEntity)this.contentHolder).getTrustListBackingContainer(), i, x, y));
            x += 18;
        }
        this.addSlot(new CardSlot.UnboundCardSlot(this.cardWritingContainer, 0, 7, 87));
        this.addPlayerSlots(40, 130);
    }

    protected void saveData(BlazeBankerBlockEntity contentHolder) {
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (playerIn instanceof ServerPlayer) {
            this.clearContainer(this.player, this.cardWritingContainer);
        }
    }

    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot clickedSlot = (Slot)this.slots.get(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = CoinItem.clearDisplayedCount(clickedSlot.getItem());
        ItemStack returnStack = slotStack.copy();
        if (index <= 27) {
            int count = slotStack.getCount();
            if (!this.moveItemStackTo(slotStack, 28, 64, false)) {
                return ItemStack.EMPTY;
            }
            returnStack = ItemStack.EMPTY;
            clickedSlot.remove(count);
        } else {
            if (slotStack.getItem() instanceof IDCardItem && IDCardItem.isBound(slotStack) && !this.moveItemStackTo(slotStack, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (NumismaticsTags.AllItemTags.CARDS.matches(slotStack) && !this.moveItemStackTo(slotStack, 27, 28, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= 28 && index < 37 && !this.moveItemStackTo(slotStack, 37, 64, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= 37 && index < 64 && !this.moveItemStackTo(slotStack, 28, 37, false)) {
                return ItemStack.EMPTY;
            }
        }
        if (slotStack.isEmpty()) {
            clickedSlot.set(ItemStack.EMPTY);
        } else {
            clickedSlot.setChanged();
        }
        return returnStack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack itemStack;
        Slot slot;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable() && startIndex >= 27) {
            while (!stack.isEmpty() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (Slot)this.slots.get(i);
                itemStack = slot.getItem();
                if (!itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) {
                    int j = itemStack.getCount() + stack.getCount();
                    if (j <= stack.getMaxStackSize()) {
                        stack.setCount(0);
                        itemStack.setCount(j);
                        slot.setChanged();
                        bl = true;
                    } else if (itemStack.getCount() < stack.getMaxStackSize()) {
                        stack.shrink(stack.getMaxStackSize() - itemStack.getCount());
                        itemStack.setCount(stack.getMaxStackSize());
                        slot.setChanged();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (Slot)this.slots.get(i);
                itemStack = slot.getItem();
                if (itemStack.isEmpty() && slot.mayPlace(stack)) {
                    if (stack.getCount() > slot.getMaxStackSize()) {
                        slot.setByPlayer(stack.split(slot.getMaxStackSize()));
                    } else {
                        slot.setByPlayer(stack.split(stack.getCount()));
                    }
                    slot.setChanged();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    private static class CardWritingContainer
    implements Container {
        private final Consumer<CardWritingContainer> slotsChangedCallback;
        private final UUID uuid;
        @NotNull
        protected final List<ItemStack> stacks = new ArrayList<ItemStack>();

        public CardWritingContainer(Consumer<CardWritingContainer> slotsChangedCallback, UUID uuid) {
            this.slotsChangedCallback = slotsChangedCallback;
            this.uuid = uuid;
            this.stacks.add(ItemStack.EMPTY);
        }

        public int getContainerSize() {
            return 1;
        }

        protected ItemStack getStack() {
            return this.stacks.get(0);
        }

        public boolean isEmpty() {
            return this.getStack().isEmpty();
        }

        @NotNull
        public ItemStack getItem(int slot) {
            return this.getStack();
        }

        @NotNull
        public ItemStack removeItem(int slot, int amount) {
            ItemStack stack = ContainerHelper.removeItem(this.stacks, (int)0, (int)amount);
            if (!stack.isEmpty()) {
                this.slotsChangedCallback.accept(this);
            }
            return stack;
        }

        @NotNull
        public ItemStack removeItemNoUpdate(int slot) {
            return ContainerHelper.takeItem(this.stacks, (int)0);
        }

        public void setItem(int slot, @NotNull ItemStack stack) {
            this.stacks.set(0, stack);
            if (!CardItem.isBound(stack) && NumismaticsTags.AllItemTags.CARDS.matches(stack)) {
                CardItem.set(stack, this.uuid);
            }
            this.slotsChangedCallback.accept(this);
        }

        public void setChanged() {
        }

        public boolean stillValid(@NotNull Player player) {
            return true;
        }

        public void clearContent() {
            this.stacks.set(0, ItemStack.EMPTY);
        }
    }
}

