/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.bank.CardSlot;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.SlotInputMergingCoinBag;
import dev.ithundxr.createnumismatics.content.coins.SlotOutputMergingCoinBag;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BankMenu
extends MenuBase<BankAccount> {
    public static final int COIN_SLOTS;
    public static final int COIN_INPUT_SLOT_INDEX;
    public static final int CARD_SLOT_INDEX;
    public static final int PLAYER_INV_START_INDEX;
    public static final int PLAYER_HOTBAR_END_INDEX;
    public static final int PLAYER_INV_END_INDEX;
    protected ContainerData dataAccess;
    private CardSwitchContainer cardSwitchContainer;

    public BankMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public BankMenu(MenuType<?> type, int id, Inventory inv, BankAccount contentHolder, ContainerData dataAccess) {
        super(type, id, inv, (Object)contentHolder);
        this.dataAccess = dataAccess;
        this.addDataSlots(dataAccess);
    }

    protected BankAccount createOnClient(RegistryFriendlyByteBuf extraData) {
        BankAccount account = BankAccount.clientSide((FriendlyByteBuf)extraData);
        this.dataAccess = account.dataAccess;
        this.addDataSlots(this.dataAccess);
        return account;
    }

    protected void initAndReadInventory(BankAccount contentHolder) {
    }

    protected void addSlots() {
        if (this.cardSwitchContainer == null) {
            this.cardSwitchContainer = new CardSwitchContainer(arg_0 -> ((BankMenu)this).slotsChanged(arg_0), this::switchTo);
        }
        int x = 13;
        int y = 71;
        for (Coin coin : Coin.values()) {
            this.addSlot(new SlotOutputMergingCoinBag(((BankAccount)this.contentHolder).linkedCoinBag, coin, x, y));
            x += 18;
        }
        this.addSlot(new SlotInputMergingCoinBag(((BankAccount)this.contentHolder).linkedCoinBag, null, 159, y));
        this.addSlot(new CardSlot.BoundCardSlot(this.cardSwitchContainer, 0, 8, 109));
        this.addPlayerSlots(40, 152);
    }

    private boolean switchTo(UUID otherAccount) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BankAccount account = Numismatics.BANK.getAccount(otherAccount);
            if (account != null) {
                if (account.isAuthorized((Player)serverPlayer)) {
                    Utils.openScreen(serverPlayer, account, account::sendToMenu);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void saveData(BankAccount contentHolder) {
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (playerIn instanceof ServerPlayer) {
            this.clearContainer(this.player, this.cardSwitchContainer);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot clickedSlot = (Slot)this.slots.get(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = CoinItem.clearDisplayedCount(clickedSlot.getItem());
        ItemStack returnStack = slotStack.copy();
        if (index <= CARD_SLOT_INDEX) {
            int count = slotStack.getCount();
            if (!this.moveItemStackTo(slotStack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.EMPTY;
            }
            returnStack = ItemStack.EMPTY;
            clickedSlot.remove(count);
        } else {
            if (slotStack.getItem() instanceof CoinItem && !this.moveItemStackTo(slotStack, COIN_INPUT_SLOT_INDEX, COIN_INPUT_SLOT_INDEX + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (NumismaticsTags.AllItemTags.CARDS.matches(slotStack) && !this.moveItemStackTo(slotStack, CARD_SLOT_INDEX, CARD_SLOT_INDEX + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= PLAYER_INV_START_INDEX && index < PLAYER_HOTBAR_END_INDEX && !this.moveItemStackTo(slotStack, PLAYER_HOTBAR_END_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= PLAYER_HOTBAR_END_INDEX && index < PLAYER_INV_END_INDEX && !this.moveItemStackTo(slotStack, PLAYER_INV_START_INDEX, PLAYER_HOTBAR_END_INDEX, false)) {
                return ItemStack.EMPTY;
            }
        }
        if (slotStack.isEmpty()) {
            clickedSlot.set(ItemStack.EMPTY);
        } else {
            clickedSlot.setChanged();
        }
        return returnStack;
    }

    static {
        COIN_INPUT_SLOT_INDEX = COIN_SLOTS = Coin.values().length;
        CARD_SLOT_INDEX = COIN_INPUT_SLOT_INDEX + 1;
        PLAYER_INV_START_INDEX = CARD_SLOT_INDEX + 1;
        PLAYER_HOTBAR_END_INDEX = PLAYER_INV_START_INDEX + 9;
        PLAYER_INV_END_INDEX = PLAYER_INV_START_INDEX + 36;
    }

    private class CardSwitchContainer
    implements Container {
        private final Consumer<CardSwitchContainer> slotsChangedCallback;
        private final Function<UUID, Boolean> uuidChangedCallback;
        @NotNull
        protected final List<ItemStack> stacks = new ArrayList<ItemStack>();

        public CardSwitchContainer(Consumer<CardSwitchContainer> slotsChangedCallback, Function<UUID, Boolean> uuidChangedCallback) {
            this.slotsChangedCallback = slotsChangedCallback;
            this.uuidChangedCallback = uuidChangedCallback;
            this.stacks.add(ItemStack.EMPTY);
        }

        public int getContainerSize() {
            return 1;
        }

        protected ItemStack getStack() {
            return this.stacks.get(0);
        }

        public boolean isEmpty() {
            return this.getStack().isEmpty();
        }

        @NotNull
        public ItemStack getItem(int slot) {
            return this.getStack();
        }

        @NotNull
        public ItemStack removeItem(int slot, int amount) {
            ItemStack stack = ContainerHelper.removeItem(this.stacks, (int)0, (int)amount);
            if (!stack.isEmpty()) {
                this.slotsChangedCallback.accept(this);
            }
            return stack;
        }

        @NotNull
        public ItemStack removeItemNoUpdate(int slot) {
            return ContainerHelper.takeItem(this.stacks, (int)0);
        }

        public void setItem(int slot, @NotNull ItemStack stack) {
            this.stacks.set(0, stack);
            if (CardItem.isBound(stack) && NumismaticsTags.AllItemTags.CARDS.matches(stack) && !this.uuidChangedCallback.apply(CardItem.get(stack)).booleanValue()) {
                this.stacks.set(0, CardItem.clear(stack));
                BankMenu.this.clearContainer(BankMenu.this.player, this);
            }
            this.slotsChangedCallback.accept(this);
        }

        public void setChanged() {
        }

        public boolean stillValid(@NotNull Player player) {
            return true;
        }

        public void clearContent() {
            this.stacks.set(0, ItemStack.EMPTY);
        }
    }
}

