/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend;

import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.BankSavedData;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalBankManager {
    private BankSavedData savedData;
    public Map<UUID, BankAccount> accounts;

    public GlobalBankManager() {
        this.cleanUp();
    }

    private void warnIfClient() {
        if (Thread.currentThread().getName().equals("Render thread")) {
            long start = System.currentTimeMillis();
            Numismatics.LOGGER.error("Bank manager should not be accessed on the client");
            if (Utils.isDevEnv()) {
                long end = System.currentTimeMillis();
                if (end - start < 50L) {
                    throw new RuntimeException("Illegal bank access performed on client, please set a breakpoint above");
                }
            } else {
                Numismatics.LOGGER.error("Stacktrace: ", (Throwable)new RuntimeException("Illegal bank access performed on client"));
            }
        }
    }

    public void levelLoaded(LevelAccessor level) {
        MinecraftServer server = level.getServer();
        if (server == null || server.overworld() != level) {
            return;
        }
        this.cleanUp();
        this.savedData = null;
        this.loadBankData(server);
    }

    private void loadBankData(MinecraftServer server) {
        if (this.savedData != null) {
            return;
        }
        this.savedData = BankSavedData.load(server);
        this.accounts = this.savedData.getAccounts();
    }

    public void cleanUp() {
        this.accounts = new HashMap<UUID, BankAccount>();
    }

    public void markBankDirty() {
        if (this.savedData != null) {
            this.savedData.setDirty();
        }
    }

    public BankAccount getAccount(Player player) {
        return this.getOrCreateAccount(player.getUUID(), BankAccount.Type.PLAYER);
    }

    @Nullable
    public BankAccount getAccount(UUID uuid) {
        this.warnIfClient();
        return this.accounts.get(uuid);
    }

    public BankAccount getOrCreateAccount(@NotNull UUID uuid, BankAccount.Type type) {
        this.warnIfClient();
        if (this.accounts.containsKey(uuid)) {
            return this.accounts.get(uuid);
        }
        if (uuid == null) {
            throw new RuntimeException("UUID cannot be null");
        }
        BankAccount account = new BankAccount(uuid, type);
        this.accounts.put(uuid, account);
        this.markBankDirty();
        return account;
    }
}

