/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.base.client.rendering;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiBlockEntityRenderBuilder<BE extends BlockEntity>
extends GuiGameElement.GuiRenderBuilder {
    private final BE blockEntity;

    protected GuiBlockEntityRenderBuilder(BE blockEntity) {
        this.blockEntity = blockEntity;
    }

    public void render(GuiGraphics graphics) {
        PoseStack matrixStack = graphics.pose();
        this.prepareMatrix(matrixStack);
        this.transformMatrix(matrixStack);
        Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 100.0f);
        matrixStack.translate(16.0f, -16.0f, 0.0f);
        matrixStack.scale(16.0f, 16.0f, 16.0f);
        Minecraft.getInstance().getItemRenderer().getModel(NumismaticsBlocks.BLAZE_BANKER.asStack(), null, null, 0).getTransforms().getTransform(ItemDisplayContext.GUI).apply(false, matrixStack);
        Lighting.setupFor3DItems();
        RenderSystem.enableDepthTest();
        Minecraft.getInstance().getBlockEntityRenderDispatcher().render(this.blockEntity, AnimationTickHolder.getPartialTicks(), matrixStack, (MultiBufferSource)graphics.bufferSource());
        RenderSystem.disableDepthTest();
        RenderSystem.enableDepthTest();
        matrixStack.popPose();
        this.cleanUpMatrix(matrixStack);
    }

    public static <BE extends BlockEntity> GuiBlockEntityRenderBuilder<BE> of(BE blockEntity) {
        return new GuiBlockEntityRenderBuilder<BE>(blockEntity);
    }
}

