/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.integration.jei;

import com.google.common.base.Preconditions;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.ApiStatus;
import plus.dragons.createdragonsplus.common.CDPCommon;
import plus.dragons.createdragonsplus.config.CDPConfig;
import plus.dragons.createdragonsplus.integration.jei.category.FanColoringCategory;
import plus.dragons.createdragonsplus.integration.jei.category.FanEndingCategory;
import plus.dragons.createdragonsplus.integration.jei.category.FanFreezingCategory;
import plus.dragons.createdragonsplus.integration.jei.category.FanSandingCategory;
import plus.dragons.createdragonsplus.util.ErrorMessages;

@JeiPlugin
public class CDPJeiPlugin
implements IModPlugin {
    public static final ResourceLocation ID = CDPCommon.asResource("jei_plugin");
    private final List<CreateRecipeCategory<?>> categories = new ArrayList();

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.categories.clear();
        if (((Boolean)CDPConfig.recipes().enableBulkColoring.get()).booleanValue()) {
            this.categories.add((CreateRecipeCategory<?>)FanColoringCategory.create());
        }
        if (((Boolean)CDPConfig.recipes().enableBulkFreezing.get()).booleanValue()) {
            this.categories.add((CreateRecipeCategory<?>)FanFreezingCategory.create());
        }
        if (((Boolean)CDPConfig.recipes().enableBulkSanding.get()).booleanValue()) {
            this.categories.add((CreateRecipeCategory<?>)FanSandingCategory.create());
        }
        if (((Boolean)CDPConfig.recipes().enableBulkEnding.get()).booleanValue()) {
            this.categories.add((CreateRecipeCategory<?>)FanEndingCategory.create());
        }
        registration.addRecipeCategories((IRecipeCategory[])this.categories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.categories.forEach(category -> category.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.categories.forEach(category -> category.registerCatalysts(registration));
    }

    @ApiStatus.Internal
    public static Level getLevel() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)ErrorMessages.notNull("minecraft"));
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)ErrorMessages.notNull("level"));
        return level;
    }

    @ApiStatus.Internal
    public static RecipeManager getRecipeManager() {
        if (FMLLoader.getDist() != Dist.CLIENT) {
            throw new IllegalStateException("Retreiving recipe manager from client level is only supported for client");
        }
        Minecraft minecraft = Minecraft.getInstance();
        Preconditions.checkNotNull((Object)minecraft, (Object)ErrorMessages.notNull("minecraft"));
        ClientLevel level = minecraft.level;
        Preconditions.checkNotNull((Object)level, (Object)ErrorMessages.notNull("level"));
        return level.getRecipeManager();
    }
}

