/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.registry;

import com.simibubi.create.api.effect.OpenPipeEffectHandler;
import com.simibubi.create.api.event.PipeCollisionEvent;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import plus.dragons.createdragonsplus.client.color.SimpleItemColors;
import plus.dragons.createdragonsplus.common.CDPCommon;
import plus.dragons.createdragonsplus.common.fluids.StandardDispenserBehaviour;
import plus.dragons.createdragonsplus.common.fluids.dragonBreath.DragonBreathFluidType;
import plus.dragons.createdragonsplus.common.fluids.dragonBreath.DragondBreathLiquidBlock;
import plus.dragons.createdragonsplus.common.fluids.dragonBreath.DragonsBreathOpenPipeEffect;
import plus.dragons.createdragonsplus.common.fluids.dye.DyeColors;
import plus.dragons.createdragonsplus.common.fluids.dye.DyeFluidOpenPipeEffect;
import plus.dragons.createdragonsplus.common.fluids.dye.DyeFluidType;
import plus.dragons.createdragonsplus.common.fluids.dye.DyeLiquidBlock;
import plus.dragons.createdragonsplus.common.registry.CDPDataMaps;
import plus.dragons.createdragonsplus.common.registry.CDPItems;
import plus.dragons.createdragonsplus.config.CDPConfig;
import plus.dragons.createdragonsplus.data.recipe.CreateRecipeBuilders;
import plus.dragons.createdragonsplus.data.tag.IntrinsicTagRegistry;

public class CDPFluids {
    public static final ModTags MOD_TAGS = new ModTags();
    public static final CommonTags COMMON_TAGS = new CommonTags();
    public static final EnumMap<DyeColor, FluidEntry<BaseFlowingFluid.Flowing>> DYES_BY_COLOR = (EnumMap)Util.make(new EnumMap(DyeColor.class), map -> {
        for (DyeColor color : DyeColors.ALL) {
            map.put(color, CDPFluids.dye(color));
        }
    });
    public static final FluidEntry<BaseFlowingFluid.Flowing> DRAGON_BREATH = ((FluidBuilder)((FluidBuilder)((FluidBuilder)((FluidBuilder)CDPCommon.REGISTRATE.fluid("dragon_breath", CDPCommon.REGISTRATE.asResource("fluid/dragon_breath_still"), CDPCommon.REGISTRATE.asResource("fluid/dragon_breath_flow"), DragonBreathFluidType.create()).lang("Dragon's Breath").properties(properties -> properties.rarity(Rarity.UNCOMMON).density(3000).viscosity(6000).lightLevel(15).motionScale(0.07).canSwim(false).canDrown(false).pathType(PathType.DAMAGE_OTHER).adjacentPathType(null).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.DRAGON_FIREBALL_EXPLODE).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY_LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA)).fluidProperties(properties -> properties.explosionResistance(100.0f).levelDecreasePerBlock(2).slopeFindDistance(2).tickRate(30)).source(BaseFlowingFluid.Source::new).onRegister(flowing -> {
        BuiltInRegistries.FLUID.addAlias(CDPCommon.REGISTRATE.asResource("dragons_breath"), CDPCommon.REGISTRATE.asResource("dragon_breath"));
        BuiltInRegistries.FLUID.addAlias(CDPCommon.REGISTRATE.asResource("flowing_dragons_breath"), CDPCommon.REGISTRATE.asResource("flowing_dragon_breath"));
    })).tag(new TagKey[]{CDPFluids.COMMON_TAGS.dragonBreath, CDPFluids.MOD_TAGS.fanEndingCatalysts}).block(DragondBreathLiquidBlock::new).lang("Dragon's Breath").build()).bucket().properties(properties -> properties.rarity(Rarity.UNCOMMON)).lang("Dragon's Breath Bucket").tag(new TagKey[]{CDPItems.COMMON_TAGS.dragonBreathBuckets}).build()).setData(ProviderType.RECIPE, (ctx, prov) -> {
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)CreateRecipeBuilders.emptying(ctx.getId().withPath("dragon_breath")).require((ItemLike)Items.DRAGON_BREATH)).output((Fluid)ctx.get(), 250)).output((ItemLike)Items.GLASS_BOTTLE)).withCondition((ICondition)CDPConfig.features().dragonBreathFluid)).build((RecipeOutput)prov);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)CreateRecipeBuilders.filling(ctx.getId().withPath("dragon_breath")).require((FlowingFluid)ctx.get(), 250)).require((ItemLike)Items.GLASS_BOTTLE)).output((ItemLike)Items.DRAGON_BREATH)).withCondition((ICondition)CDPConfig.features().dragonBreathFluid)).build((RecipeOutput)prov);
    })).register();

    public static void register(IEventBus modBus) {
        modBus.register(CDPFluids.class);
        CDPCommon.REGISTRATE.registerFluidTags(MOD_TAGS);
        CDPCommon.REGISTRATE.registerFluidTags(COMMON_TAGS);
    }

    public static void registerDispenserBehavior() {
        DYES_BY_COLOR.values().forEach(dyeFluid -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)dyeFluid.getBucket().get()), (DispenseItemBehavior)StandardDispenserBehaviour.INSTANCE));
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)DRAGON_BREATH.getBucket().get()), (DispenseItemBehavior)StandardDispenserBehaviour.INSTANCE);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(Reactions::registerFluidInteractions);
        event.enqueueWork(Reactions::registerOpenPipeEffects);
        event.enqueueWork(CDPFluids::registerDispenserBehavior);
    }

    private static FluidEntry<BaseFlowingFluid.Flowing> dye(DyeColor color) {
        ResourceLocation stillTexture = CDPCommon.REGISTRATE.asResource("fluid/dye_still");
        ResourceLocation flowingTexture = CDPCommon.REGISTRATE.asResource("fluid/dye_flow");
        int tintColor = FastColor.ARGB32.opaque((int)color.getTextureDiffuseColor());
        String name = color.getName() + "_dye";
        TagKey<Fluid> tag = CDPFluids.COMMON_TAGS.dyesByColor.get(color);
        return ((FluidBuilder)((FluidBuilder)((FluidBuilder)((FluidBuilder)CDPCommon.REGISTRATE.fluid(name, stillTexture, flowingTexture, DyeFluidType.create(color)).properties(properties -> properties.fallDistanceModifier(0.0f).canExtinguish(true).supportsBoating(true).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH)).fluidProperties(properties -> properties.explosionResistance(100.0f)).block((fluid, prop) -> new DyeLiquidBlock(color, (FlowingFluid)fluid, (BlockBehaviour.Properties)prop)).build()).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{CDPItems.COMMON_TAGS.dyeBucketsByColor.get(color)}).model((ctx, prov) -> prov.withExistingParent(ctx.getName(), prov.modLoc("dye_bucket"))).color(() -> SimpleItemColors.singleLayer(tintColor)).tag(new TagKey[]{color.getDyedTag()}).build()).tag(new TagKey[]{tag}).setData(ProviderType.RECIPE, (ctx, prov) -> {
            ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)CreateRecipeBuilders.mixing(ctx.getId().withPath(name + "_from_item")).require((ItemLike)DyeItem.byColor((DyeColor)color))).require(Fluids.WATER, 250)).output((Fluid)ctx.get(), 250)).withCondition((ICondition)CDPConfig.features().dyeFluids)).build((RecipeOutput)prov);
            ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)CreateRecipeBuilders.mixing(ctx.getId().withPath(name + "_from_fluid")).require((FlowingFluid)ctx.get(), 250)).output((ItemLike)DyeItem.byColor((DyeColor)color))).requiresHeat(HeatCondition.HEATED)).withCondition((ICondition)CDPConfig.features().dyeFluids)).build((RecipeOutput)prov);
        })).setData(ProviderType.DATA_MAP, (ctx, prov) -> prov.builder(CDPDataMaps.FLUID_FAN_COLORING_CATALYSTS).add(tag, (Object)color, false, new ICondition[0]))).register();
    }

    public static class ModTags
    extends IntrinsicTagRegistry<Fluid, RegistrateTagsProvider.IntrinsicImpl<Fluid>> {
        public final TagKey<Fluid> fanEndingCatalysts = this.tag("fan_processing_catalysts/ending", "Bulk Ending Catalysts");

        public ModTags() {
            super("create_dragons_plus", Registries.FLUID);
        }
    }

    public static class CommonTags
    extends IntrinsicTagRegistry<Fluid, RegistrateTagsProvider.IntrinsicImpl<Fluid>> {
        public final TagKey<Fluid> dyes = this.tag("dyes", "Dyes");
        public final EnumMap<DyeColor, TagKey<Fluid>> dyesByColor = (EnumMap)Util.make(new EnumMap(DyeColor.class), map -> {
            for (DyeColor color : DyeColors.ALL) {
                TagKey tag = this.tag("dyes/" + color.getName(), DyeColors.LOCALIZATION.get(color) + " Dye");
                map.put(color, tag);
                this.addTag(this.dyes, tag);
            }
        });
        public final TagKey<Fluid> dragonBreath = this.tag("dragon_breath", "Dragon's Breath");

        protected CommonTags() {
            super("c", Registries.FLUID);
        }
    }

    @EventBusSubscriber
    public static class Reactions {
        private static final Map<FluidType, BlockState> LAVA_INTERACTIONS = new HashMap<FluidType, BlockState>();

        @SubscribeEvent
        public static void onPipeCollisionFlow(PipeCollisionEvent.Flow event) {
            FluidType first = event.getFirstFluid().getFluidType();
            FluidType second = event.getSecondFluid().getFluidType();
            if (first == NeoForgeMod.LAVA_TYPE.value() && LAVA_INTERACTIONS.containsKey(second)) {
                event.setState(LAVA_INTERACTIONS.get(second));
            } else if (second == NeoForgeMod.LAVA_TYPE.value() && LAVA_INTERACTIONS.containsKey(first)) {
                event.setState(LAVA_INTERACTIONS.get(first));
            }
        }

        @SubscribeEvent
        public static void onPipeCollisionSpill(PipeCollisionEvent.Spill event) {
            Fluid world = event.getWorldFluid();
            Fluid pipe = event.getPipeFluid();
            FluidType worldType = world.getFluidType();
            FluidType pipeType = pipe.getFluidType();
            if (worldType == NeoForgeMod.LAVA_TYPE.value() && LAVA_INTERACTIONS.containsKey(pipeType)) {
                if (world.isSource(world.defaultFluidState())) {
                    event.setState(Blocks.OBSIDIAN.defaultBlockState());
                } else {
                    event.setState(LAVA_INTERACTIONS.get(pipeType));
                }
            } else if (pipeType == NeoForgeMod.LAVA_TYPE.value() && LAVA_INTERACTIONS.containsKey(worldType)) {
                if (pipe.isSource(pipe.defaultFluidState())) {
                    event.setState(Blocks.OBSIDIAN.defaultBlockState());
                } else {
                    event.setState(LAVA_INTERACTIONS.get(worldType));
                }
            }
        }

        static void registerFluidInteractions() {
            Boolean genConcrete = CDPConfig.common().features.dyeFluidsLavaInteractionGenerateColoredConcrete.get();
            DYES_BY_COLOR.forEach((color, entry) -> {
                FluidType type = entry.getType();
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)color.getName()).withSuffix("_concrete"));
                if (block == Blocks.AIR) {
                    return;
                }
                LAVA_INTERACTIONS.put(type, genConcrete != false ? block.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState());
                FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(type, fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : (genConcrete != false ? block.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState())));
            });
            LAVA_INTERACTIONS.put(DRAGON_BREATH.getType(), Blocks.END_STONE.defaultBlockState());
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(DRAGON_BREATH.getType(), fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.END_STONE.defaultBlockState()));
        }

        static void registerOpenPipeEffects() {
            DYES_BY_COLOR.forEach((color, entry) -> OpenPipeEffectHandler.REGISTRY.register((Object)entry.getSource(), (Object)new DyeFluidOpenPipeEffect((DyeColor)color)));
            OpenPipeEffectHandler.REGISTRY.register((Object)DRAGON_BREATH.getSource(), (Object)new DragonsBreathOpenPipeEffect());
        }
    }
}

