/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.fluids.hatch;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.fluids.hatch.FluidHatchBlockEntity;
import plus.dragons.createdragonsplus.common.registry.CDPBlockEntities;

public class FluidHatchBlock
extends HorizontalDirectionalBlock
implements IBE<FluidHatchBlockEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final MapCodec<FluidHatchBlock> CODEC = FluidHatchBlock.simpleCodec(FluidHatchBlock::new);

    public FluidHatchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, WATERLOGGED}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        if (context.getClickedFace().getAxis().isVertical()) {
            return null;
        }
        return this.withWater((BlockState)state.setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite()), context);
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return state;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        SoundEvent soundevent;
        FluidHelper.FluidExchange exchange;
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (player instanceof FakePlayer) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos.relative((Direction)state.getValue((Property)FACING)));
        if (blockEntity == null) {
            return ItemInteractionResult.FAIL;
        }
        IFluidHandler tankCapability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, blockEntity.getBlockPos(), null);
        if (tankCapability == null) {
            return ItemInteractionResult.FAIL;
        }
        FilteringBehaviour filter = (FilteringBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)FilteringBehaviour.TYPE);
        if (filter == null) {
            return ItemInteractionResult.FAIL;
        }
        FluidStack fluidStack = this.tryEmptyItem(level, player, hand, stack, blockEntity, tankCapability, filter);
        if (!fluidStack.isEmpty()) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else {
            fluidStack = this.tryFillItem(level, player, hand, stack, blockEntity, tankCapability, filter);
            if (!fluidStack.isEmpty()) {
                exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
            } else {
                if (GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack) || GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack)) {
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.FAIL;
            }
        }
        switch (exchange) {
            default: {
                throw new MatchException(null, null);
            }
            case ITEM_TO_TANK: {
                SoundEvent soundEvent = FluidHelper.getEmptySound((FluidStack)fluidStack);
                break;
            }
            case TANK_TO_ITEM: {
                SoundEvent soundEvent = soundevent = FluidHelper.getFillSound((FluidStack)fluidStack);
            }
        }
        if (soundevent != null && !level.isClientSide) {
            float pitch = Mth.clamp((float)(1.0f - (float)fluidStack.getAmount() / ((float)FluidTankBlockEntity.getCapacityMultiplier() * 16.0f)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            level.playSound(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (level.random.nextFloat() - 0.5f) / 4.0f);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public FluidStack tryEmptyItem(Level level, Player player, InteractionHand hand, ItemStack stack, BlockEntity blockEntity, IFluidHandler capability, FilteringBehaviour filter) {
        if (!GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack)) {
            return FluidStack.EMPTY;
        }
        Pair emptying = GenericItemEmptying.emptyItem((Level)level, (ItemStack)stack, (boolean)true);
        FluidStack fluidStack = (FluidStack)emptying.getFirst();
        if (!filter.test(fluidStack)) {
            return FluidStack.EMPTY;
        }
        if (fluidStack.getAmount() != capability.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE)) {
            return FluidStack.EMPTY;
        }
        if (level.isClientSide) {
            return fluidStack;
        }
        ItemStack copy = stack.copy();
        emptying = GenericItemEmptying.emptyItem((Level)level, (ItemStack)copy, (boolean)false);
        capability.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
        blockEntity.setChanged();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(blockEntity.getBlockPos());
        }
        if (!player.isCreative() && !(blockEntity instanceof CreativeFluidTankBlockEntity)) {
            if (copy.isEmpty()) {
                player.setItemInHand(hand, (ItemStack)emptying.getSecond());
            } else {
                player.setItemInHand(hand, copy);
                player.getInventory().placeItemBackInInventory((ItemStack)emptying.getSecond());
            }
        }
        return fluidStack;
    }

    public FluidStack tryFillItem(Level level, Player player, InteractionHand hand, ItemStack stack, BlockEntity blockEntity, IFluidHandler capability, FilteringBehaviour filter) {
        if (!GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack)) {
            return FluidStack.EMPTY;
        }
        for (int i = 0; i < capability.getTanks(); ++i) {
            int requiredAmountForItem;
            FluidStack fluidStack = capability.getFluidInTank(i);
            if (fluidStack.isEmpty() || !filter.test(fluidStack) || (requiredAmountForItem = GenericItemFilling.getRequiredAmountForItem((Level)level, (ItemStack)stack, (FluidStack)fluidStack.copy())) == -1 || requiredAmountForItem > fluidStack.getAmount()) continue;
            if (level.isClientSide) {
                return fluidStack;
            }
            if (player.isCreative() || blockEntity instanceof CreativeFluidTankBlockEntity) {
                stack = stack.copy();
            }
            ItemStack result = GenericItemFilling.fillItem((Level)level, (int)requiredAmountForItem, (ItemStack)stack, (FluidStack)fluidStack.copy());
            FluidStack fluidCopy = fluidStack.copy();
            fluidCopy.setAmount(requiredAmountForItem);
            capability.drain(fluidCopy, IFluidHandler.FluidAction.EXECUTE);
            if (!player.isCreative()) {
                if (player.getItemInHand(hand).isEmpty()) {
                    player.setItemInHand(hand, result);
                } else {
                    player.getInventory().placeItemBackInInventory(result);
                }
            }
            blockEntity.setChanged();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.getChunkSource().blockChanged(blockEntity.getBlockPos());
            }
            return fluidCopy;
        }
        return FluidStack.EMPTY;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AllShapes.ITEM_HATCH.get(((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<FluidHatchBlockEntity> getBlockEntityClass() {
        return FluidHatchBlockEntity.class;
    }

    public BlockEntityType<? extends FluidHatchBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDPBlockEntities.FLUID_HATCH.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

