/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.noisium.mixin;

import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LevelChunkSection.class})
public class ChunkSectionMixin {
    @Unique
    private static final int noisium$sliceSize = 4;
    @Shadow
    private PalettedContainerRO<Holder<Biome>> biomes;

    @Overwrite
    public void fillBiomesFromNoise(BiomeResolver biomeSupplier, Climate.Sampler sampler, int x, int y, int z) {
        PalettedContainer palettedContainer = this.biomes.recreate();
        for (int posY = 0; posY < 4; ++posY) {
            for (int posZ = 0; posZ < 4; ++posZ) {
                for (int posX = 0; posX < 4; ++posX) {
                    palettedContainer.getAndSetUnchecked(posX, posY, posZ, (Object)biomeSupplier.getNoiseBiome(x + posX, y + posY, z + posZ, sampler));
                }
            }
        }
        this.biomes = palettedContainer;
    }
}

