/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_polaroid.client.gui.screen.camera.button;

import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure_polaroid.ExposurePolaroid;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ExposureSliderButton
extends Button {
    public static final ResourceLocation BASE = ExposurePolaroid.resource("camera_controls/exposure_slider_base");
    public static final WidgetSprites SLIDER = new WidgetSprites(ExposurePolaroid.resource("camera_controls/exposure_slider"), ExposurePolaroid.resource("camera_controls/exposure_slider_disabled"), ExposurePolaroid.resource("camera_controls/exposure_slider_highlighted"));
    protected static final int SLIDER_WIDTH = 122;
    protected static final int SLIDER_HEIGHT = 15;
    protected static final int SLIDER_MOVEMENT_RANGE = 58;
    protected final Camera camera;

    public ExposureSliderButton(int x, int y, Camera camera) {
        super(x, y, 79, 15, (Component)Component.empty(), b -> {}, n -> Component.empty());
        this.camera = camera;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ShutterSpeed shutterSpeed;
        int indexOf;
        guiGraphics.blitSprite(BASE, this.getX(), this.getY() + 1, this.width, this.height - 1);
        List<ShutterSpeed> shutterSpeeds = this.camera.map((i, s) -> i.getAvailableShutterSpeeds()).orElse(List.of(ShutterSpeed.DEFAULT));
        if (shutterSpeeds.isEmpty()) {
            shutterSpeeds = List.of(ShutterSpeed.DEFAULT);
        }
        int index = (indexOf = shutterSpeeds.indexOf(shutterSpeed = (ShutterSpeed)CameraSettings.SHUTTER_SPEED.getOrDefault(this.camera))) == -1 ? shutterSpeeds.size() / 2 : indexOf;
        float position = 1.0f - (float)index / (float)(shutterSpeeds.size() - 1);
        int offset = Math.round(58.0f * position);
        ResourceLocation sliderSprite = SLIDER.get(this.isActive(), this.isHoveredOrFocused());
        guiGraphics.blitSprite(sliderSprite, 122, 15, offset, 0, this.getX() + 8, this.getY(), 64, 15);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0) {
            this.moveSlider(Mth.sign((double)scrollY));
            return true;
        }
        return false;
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.setSliderToMousePosition(mouseX);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.clicked(mouseX, mouseY)) {
            if (this.isValidClickButton(button)) {
                this.setSliderToMousePosition(mouseX);
                return true;
            }
            if (button == 1) {
                ShutterSpeed newShutterSpeed;
                List<ShutterSpeed> shutterSpeeds = this.camera.map((i, s) -> i.getAvailableShutterSpeeds()).orElse(List.of(ShutterSpeed.DEFAULT));
                if (shutterSpeeds.isEmpty()) {
                    return true;
                }
                int defaultIndex = shutterSpeeds.indexOf(ShutterSpeed.DEFAULT);
                int index = defaultIndex != -1 ? defaultIndex : shutterSpeeds.size() / 2;
                ShutterSpeed shutterSpeed = (ShutterSpeed)CameraSettings.SHUTTER_SPEED.getOrDefault(this.camera);
                if (!shutterSpeed.equals((Object)(newShutterSpeed = shutterSpeeds.get(index)))) {
                    CameraSettings.SHUTTER_SPEED.setAndSync(this.camera, (Object)newShutterSpeed);
                }
                return true;
            }
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.moveSlider(-1);
            return true;
        }
        if (keyCode == 262) {
            this.moveSlider(1);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void setSliderToMousePosition(double mouseX) {
        ShutterSpeed newShutterSpeed;
        List<ShutterSpeed> shutterSpeeds = this.camera.map((i, s) -> i.getAvailableShutterSpeeds()).orElse(List.of(ShutterSpeed.DEFAULT));
        if (shutterSpeeds.isEmpty()) {
            return;
        }
        int start = this.getX() + 8;
        int end = this.getX() + 8 + 64;
        int range = end - start;
        int distancePerNotch = range / shutterSpeeds.size();
        int index = (int)Mth.clamp((double)((mouseX - (double)start) / (double)distancePerNotch), (double)0.0, (double)(shutterSpeeds.size() - 1));
        ShutterSpeed shutterSpeed = (ShutterSpeed)CameraSettings.SHUTTER_SPEED.getOrDefault(this.camera);
        if (!shutterSpeed.equals((Object)(newShutterSpeed = shutterSpeeds.get(index)))) {
            CameraSettings.SHUTTER_SPEED.setAndSync(this.camera, (Object)newShutterSpeed);
        }
    }

    protected boolean moveSlider(int direction) {
        ShutterSpeed currentShutterSpeed;
        direction = Mth.sign((double)direction);
        List<ShutterSpeed> shutterSpeeds = this.camera.map((i, s) -> i.getAvailableShutterSpeeds()).orElse(List.of(ShutterSpeed.DEFAULT));
        int indexOf = shutterSpeeds.indexOf(currentShutterSpeed = (ShutterSpeed)CameraSettings.SHUTTER_SPEED.getOrDefault(this.camera));
        int index = indexOf == -1 ? shutterSpeeds.size() / 2 : indexOf;
        ShutterSpeed newShutterSpeed = shutterSpeeds.get(index = Mth.clamp((int)(index + direction), (int)0, (int)(shutterSpeeds.size() - 1)));
        if (!currentShutterSpeed.equals((Object)newShutterSpeed)) {
            CameraSettings.SHUTTER_SPEED.setAndSync(this.camera, (Object)newShutterSpeed);
            return true;
        }
        return false;
    }
}

