/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_polaroid.client.camera.viewfinder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderOverlay;
import io.github.mortuusars.exposure.client.util.GuiUtil;
import io.github.mortuusars.exposure.util.Rect2f;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure_polaroid.ExposurePolaroid;
import io.github.mortuusars.exposure_polaroid.world.item.InstantCameraItem;
import io.github.mortuusars.exposure_polaroid.world.item.camera.InstantCameraAttachment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InstantCameraViewfinderOverlay
extends ViewfinderOverlay {
    public static final ResourceLocation VIEWFINDER_TEXTURE = ExposurePolaroid.resource("textures/gui/viewfinder/viewfinder.png");
    public static final ResourceLocation NO_SLIDES_ICON_TEXTURE = ExposurePolaroid.resource("textures/gui/viewfinder/no_slides.png");
    public static final ResourceLocation REMAINING_SLIDES_ICON_TEXTURE = ExposurePolaroid.resource("textures/gui/viewfinder/remaining_slides.png");

    public InstantCameraViewfinderOverlay(Camera camera, Viewfinder viewfinder) {
        super(camera, viewfinder);
    }

    protected void drawViewfinderTexture(GuiGraphics guiGraphics) {
        GuiUtil.blit((ResourceLocation)VIEWFINDER_TEXTURE, (PoseStack)guiGraphics.pose(), (Rect2f)this.opening, (int)0, (int)0, (int)((int)this.opening.width), (int)((int)this.opening.height), (float)0.0f);
    }

    protected void renderStatusIcons(PoseStack poseStack, ItemStack cameraStack) {
        ItemStack slideStack = InstantCameraAttachment.INSTANT_SLIDE.get(cameraStack).getForReading();
        if (slideStack.isEmpty()) {
            this.renderNoSlidesIcon(poseStack);
            return;
        }
        this.renderRemainingSlidesIcon(poseStack, cameraStack);
    }

    protected void renderNoSlidesIcon(PoseStack poseStack) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)NO_SLIDES_ICON_TEXTURE);
        int x = (int)(this.opening.x + this.opening.width / 2.0f - 12.0f);
        int y = (int)(this.opening.y + this.opening.height - 18.0f);
        GuiUtil.blit((PoseStack)poseStack, (float)x, (float)y, (float)23.0f, (float)18.0f, (int)0, (int)0, (int)23, (int)18, (float)0.0f);
    }

    protected void renderRemainingSlidesIcon(PoseStack poseStack, ItemStack cameraStack) {
        Item item = cameraStack.getItem();
        if (!(item instanceof InstantCameraItem)) {
            return;
        }
        InstantCameraItem instantCamera = (InstantCameraItem)item;
        int maxSlides = instantCamera.getMaxSlideCount();
        int remainingSlides = instantCamera.getRemainingSlides(cameraStack);
        if (maxSlides > 5 && remainingSlides <= 3) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)REMAINING_SLIDES_ICON_TEXTURE);
            float x = (int)(this.opening.x + this.opening.width / 2.0f - 17.0f);
            float y = (int)(this.opening.y + this.opening.height - 15.0f);
            int vOffset = (remainingSlides - 1) * 15;
            GuiUtil.blit((PoseStack)poseStack, (float)x, (float)y, (float)33.0f, (float)15.0f, (int)0, (int)vOffset, (int)33, (int)45, (float)0.0f);
        }
    }
}

