/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_polaroid.client.animation;

import io.github.mortuusars.exposure.client.animation.CameraPoses;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class InstantCameraPoses
extends CameraPoses {
    public void applyHolding(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        boolean mirror = arm == HumanoidArm.LEFT;
        ModelPart cameraArm = mirror ? model.leftArm : model.rightArm;
        cameraArm.xRot = Mth.clamp((float)(model.head.xRot - 2.0f), (float)-3.3f, (float)-0.35f);
        cameraArm.yRot = model.head.yRot;
        float xVal = Mth.map((float)cameraArm.xRot, (float)-3.3f, (float)-0.35f, (float)-0.3f, (float)0.3f);
        if (!mirror) {
            xVal *= -1.0f;
        }
        cameraArm.zRot += xVal;
        ModelPart supportingArm = mirror ? model.rightArm : model.leftArm;
        supportingArm.xRot = Mth.clamp((float)(model.head.xRot - 1.65f), (float)-2.95f, (float)0.0f);
        supportingArm.yRot = model.head.yRot - 0.4f * (float)(!mirror ? -1 : 1);
        float supXVal = Mth.map((float)cameraArm.xRot, (float)-3.3f, (float)-0.35f, (float)-0.3f, (float)0.3f);
        if (mirror) {
            supXVal *= -1.0f;
        }
        supportingArm.zRot += supXVal;
        float actionAnim = this.getCameraActionAnim(entity);
        supportingArm.xRot = supportingArm.xRot + actionAnim * 0.1f * (float)(mirror ? -1 : 1);
        supportingArm.yRot = supportingArm.yRot + actionAnim * 0.1f * (float)(mirror ? -1 : 1);
    }
}

