/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.CalculateDetachedCameraDistanceEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    protected static final ResourceLocation EXPERIENCE_BAR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/experience_bar_background");
    protected static final ResourceLocation EXPERIENCE_BAR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/experience_bar_progress");
    private static final Minecraft mc = Minecraft.getInstance();

    @SubscribeEvent
    public void onCameraDistance(CalculateDetachedCameraDistanceEvent evt) {
        if (RenderEvents.getCar() != null && !RenderEvents.mc.options.getCameraType().isFirstPerson()) {
            evt.setDistance(((Double)Main.CLIENT_CONFIG.carZoom.get()).floatValue());
        }
    }

    @SubscribeEvent
    public void onRender(InputEvent.MouseScrollingEvent evt) {
        if (RenderEvents.getCar() != null && !RenderEvents.mc.options.getCameraType().isFirstPerson()) {
            Main.CLIENT_CONFIG.carZoom.set((Object)Math.max(1.0, Math.min(20.0, (Double)Main.CLIENT_CONFIG.carZoom.get() - evt.getScrollDeltaY())));
            Main.CLIENT_CONFIG.carZoom.save();
            evt.setCanceled(true);
        }
    }

    private static EntityGenericCar getCar() {
        if (RenderEvents.mc.player == null) {
            return null;
        }
        Entity e = RenderEvents.mc.player.getVehicle();
        if (e instanceof EntityGenericCar) {
            return (EntityGenericCar)e;
        }
        return null;
    }

    public static boolean onRenderExperienceBar(GuiGraphics guiGraphics, int i) {
        LocalPlayer player = RenderEvents.mc.player;
        EntityGenericCar car = RenderEvents.getCar();
        if (car == null || player == null) {
            return false;
        }
        if (!player.equals((Object)car.getDriver())) {
            return false;
        }
        RenderEvents.renderFuelBar(guiGraphics, (float)car.getFuelAmount() / (float)car.getMaxFuel());
        RenderEvents.renderSpeed(guiGraphics, car.getKilometerPerHour());
        return true;
    }

    public static void renderFuelBar(GuiGraphics guiGraphics, float percent) {
        percent = Mth.clamp((float)percent, (float)0.0f, (float)1.0f);
        int x = mc.getWindow().getGuiScaledWidth() / 2 - 91;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = mc.getWindow().getGuiScaledHeight() - 32 + 3;
        guiGraphics.blitSprite(EXPERIENCE_BAR_BACKGROUND_SPRITE, x, k, 182, 5);
        int j = (int)(percent * 182.0f);
        if (j > 0) {
            guiGraphics.blitSprite(EXPERIENCE_BAR_PROGRESS_SPRITE, 182, 5, 0, 0, x, k, j, 5);
        }
    }

    public static void renderSpeed(GuiGraphics guiGraphics, float speed) {
        Font font = RenderEvents.mc.gui.getFont();
        String s = String.valueOf(MathUtils.round(Math.abs(speed), 2));
        int i1 = (mc.getWindow().getGuiScaledWidth() - font.width(s)) / 2;
        int j1 = mc.getWindow().getGuiScaledHeight() - 31 - 4;
        guiGraphics.drawString(font, s, i1 + 1, j1, 0, false);
        guiGraphics.drawString(font, s, i1 - 1, j1, 0, false);
        guiGraphics.drawString(font, s, i1, j1 + 1, 0, false);
        guiGraphics.drawString(font, s, i1, j1 - 1, 0, false);
        guiGraphics.drawString(font, s, i1, j1, 8453920, false);
    }

    @SubscribeEvent
    public void renderToolTip(RenderTooltipEvent.Pre event) {
        if (event.getItemStack().has(Main.TRADING_ITEM_DATA_COMPONENT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        EntityGenericCar car = RenderEvents.getCar();
        if (car != null) {
            event.getPoseStack().pushPose();
            event.getPoseStack().scale(EntityVehicleBase.SCALE_FACTOR, EntityVehicleBase.SCALE_FACTOR, EntityVehicleBase.SCALE_FACTOR);
            event.getPoseStack().translate(0.0, (double)(event.getEntity().getBbHeight() - event.getEntity().getBbHeight() * EntityVehicleBase.SCALE_FACTOR) / 1.5 + car.getPlayerYOffset(), 0.0);
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        if (RenderEvents.getCar() != null) {
            event.getPoseStack().popPose();
        }
    }
}

