/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.fluids.ModFluids;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public abstract class EntityCarFuelBase
extends EntityCarDamageBase
implements IFluidHandler {
    private static final EntityDataAccessor<Integer> FUEL_AMOUNT = SynchedEntityData.defineId(EntityCarFuelBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> FUEL_TYPE = SynchedEntityData.defineId(EntityCarFuelBase.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public EntityCarFuelBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public abstract int getMaxFuel();

    @Override
    public void tick() {
        super.tick();
        this.fuelTick();
    }

    protected void fuelTick() {
        int fuel = this.getFuelAmount();
        int tickFuel = this.getEfficiency(this.getFluid());
        if (tickFuel <= 0) {
            return;
        }
        if (fuel > 0 && this.isAccelerating()) {
            if (this.tickCount % tickFuel == 0) {
                this.acceleratingFuelTick();
            }
        } else if (fuel > 0 && this.isStarted() && this.tickCount % (tickFuel * 100) == 0) {
            this.idleFuelTick();
        }
    }

    protected void idleFuelTick() {
        this.removeFuel(1);
    }

    protected void acceleratingFuelTick() {
        this.removeFuel(1);
    }

    private void removeFuel(int amount) {
        int fuel = this.getFuelAmount();
        int newFuel = fuel - amount;
        this.setFuelAmount(Math.max(newFuel, 0));
    }

    @Override
    public boolean canPlayerDriveCar(Player player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canPlayerDriveCar(player);
    }

    @Override
    public boolean canStartCarEngine(Player player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canStartCarEngine(player);
    }

    @Override
    public boolean canEngineStayOn() {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canEngineStayOn();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FUEL_AMOUNT, (Object)0);
        builder.define(FUEL_TYPE, (Object)"");
    }

    public void setFuelAmount(int fuel) {
        this.entityData.set(FUEL_AMOUNT, (Object)fuel);
    }

    public void setFuelType(String fluid) {
        if (fluid == null) {
            fluid = "";
        }
        this.entityData.set(FUEL_TYPE, (Object)fluid);
    }

    public void setFuelType(Fluid fluid) {
        this.setFuelType(BuiltInRegistries.FLUID.getKey((Object)fluid).toString());
    }

    public String getFuelType() {
        return (String)this.entityData.get(FUEL_TYPE);
    }

    @Nullable
    public Fluid getFluid() {
        String fuelType = this.getFuelType();
        if (fuelType == null || fuelType.isEmpty()) {
            return null;
        }
        return (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)fuelType));
    }

    public int getFuelAmount() {
        return (Integer)this.entityData.get(FUEL_AMOUNT);
    }

    public boolean isValidFuel(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return this.getEfficiency(fluid) > 0;
    }

    public abstract int getEfficiency(@Nullable Fluid var1);

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("fuel", this.getFuelAmount());
        compound.putString("fuel_type", this.getFuelType());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFuelAmount(compound.getInt("fuel"));
        if (compound.contains("fuel_type")) {
            this.setFuelType(compound.getString("fuel_type"));
        }
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Fluid f = this.getFluid();
        if (f == null) {
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL.get(), this.getFuelAmount());
        }
        return new FluidStack(f, this.getFuelAmount());
    }

    public int getTankCapacity(int tank) {
        return this.getMaxFuel();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFuel(stack.getFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || !this.isValidFuel(resource.getFluid())) {
            return 0;
        }
        if (this.getFluid() != null && this.getFuelAmount() > 0 && !resource.getFluid().equals(this.getFluid())) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), this.getMaxFuel() - this.getFuelAmount());
        if (action.execute()) {
            int i = this.getFuelAmount() + amount;
            if (i > this.getMaxFuel()) {
                i = this.getMaxFuel();
            }
            this.setFuelAmount(i);
            this.setFuelType(resource.getFluid());
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null) {
            return FluidStack.EMPTY;
        }
        if (resource.getFluid() == null || !resource.getFluid().equals(this.getFluid())) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Fluid fluid = this.getFluid();
        int totalAmount = this.getFuelAmount();
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, totalAmount);
        if (action.execute()) {
            int newAmount = totalAmount - amount;
            if (newAmount <= 0) {
                this.setFuelType((String)null);
                this.setFuelAmount(0);
            } else {
                this.setFuelAmount(newAmount);
            }
        }
        return new FluidStack(fluid, amount);
    }
}

