/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.corelib.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class TileEntitySpecialRendererTank
implements BlockEntityRenderer<TileEntityTank> {
    public static final ResourceLocation LOCATION_TANK = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/block/tank_line.png");
    protected BlockEntityRendererProvider.Context renderer;

    public TileEntitySpecialRendererTank(BlockEntityRendererProvider.Context renderer) {
        this.renderer = renderer;
    }

    public void render(TileEntityTank te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.pushPose();
        float amount = te.getFillPercent();
        FluidStack stack = te.getFluid();
        if (amount > 0.0f && stack != null) {
            this.renderFluid(te, stack, amount, 0.0f, matrixStack, buffer, light, overlay);
        }
        TileEntitySpecialRendererTank.renderLines(te, matrixStack, buffer, light, overlay);
        matrixStack.popPose();
    }

    public void renderFluid(TileEntityTank tank, FluidStack fluid, float amount, float yStart, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        ResourceLocation stillTexture;
        int tint;
        matrixStack.pushPose();
        VertexConsumer builder = buffer.getBuffer(Sheets.translucentCullBlockSheet());
        IClientFluidTypeExtensions type = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        if (tank.hasLevel()) {
            tint = type.getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)tank.getLevel(), tank.getBlockPos());
            stillTexture = type.getStillTexture(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)tank.getLevel(), tank.getBlockPos());
        } else {
            tint = type.getTintColor(fluid);
            stillTexture = type.getStillTexture(fluid);
        }
        TextureAtlasSprite texture = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(stillTexture);
        float uMin = texture.getU0();
        float uMax = texture.getU1();
        float vMin = texture.getV0();
        float vMax = texture.getV1();
        float vHeight = vMax - vMin;
        int red = tint >> 16 & 0xFF;
        int green = tint >> 8 & 0xFF;
        int blue = tint & 0xFF;
        float s = 0.0f;
        if (!tank.isFluidConnected(Direction.NORTH)) {
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f - s, yStart, 0.0f + s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.SOUTH)) {
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMax, vMin, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.EAST)) {
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMax, vMin, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.WEST)) {
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin + vHeight * amount, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.DOWN)) {
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 1.0f - s, uMin, vMax, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart, 0.0f + s, uMax, vMax, red, green, blue, light, overlay);
        }
        if (!tank.isFluidConnected(Direction.UP)) {
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMax, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 0.0f + s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMax, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 1.0f - s, uMin, vMin, red, green, blue, light, overlay);
            RenderUtils.vertex(builder, matrixStack, 1.0f - s, yStart + amount - s * 2.0f, 0.0f + s, uMax, vMin, red, green, blue, light, overlay);
        }
        matrixStack.popPose();
    }

    public static void renderLines(TileEntityTank te, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        VertexConsumer builder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)LOCATION_TANK));
        for (Direction facing : Direction.values()) {
            if (te.isTankConnectedTo(facing)) continue;
            for (EnumDirection direction : EnumDirection.values()) {
                if (te.isTankConnectedTo(direction.to(facing))) continue;
                TileEntitySpecialRendererTank.drawLine(facing, direction, matrixStack, buffer, builder, light, overlay);
            }
        }
    }

    public static void drawLine(Direction side, EnumDirection line, PoseStack matrixStack, MultiBufferSource buffer, VertexConsumer builder, int light, int overlay) {
        matrixStack.pushPose();
        TileEntitySpecialRendererTank.rotate(side, matrixStack);
        matrixStack.translate(-2.5E-4, -2.5E-4, -2.5E-4);
        TileEntitySpecialRendererTank.drawSide(line, side, matrixStack, buffer, builder, light, overlay);
        matrixStack.popPose();
    }

    public static void rotate(Direction facing, PoseStack matrixStack) {
        matrixStack.translate(0.5, 0.5, 0.5);
        switch (facing) {
            case SOUTH: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case WEST: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case UP: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                matrixStack.mulPose(Axis.XP.rotationDegrees(270.0f));
                break;
            }
        }
        matrixStack.translate(-0.5, -0.5, -0.5);
    }

    public static void drawSide(EnumDirection line, Direction side, PoseStack matrixStack, MultiBufferSource buffer, VertexConsumer builder, int light, int overlay) {
        switch (line.ordinal()) {
            case 0: {
                RenderUtils.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                break;
            }
            case 1: {
                RenderUtils.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                break;
            }
            case 3: {
                RenderUtils.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                break;
            }
            case 2: {
                RenderUtils.vertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, light, overlay);
                RenderUtils.vertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, light, overlay);
                break;
            }
        }
    }

    public static enum EnumDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;


        public Direction to(Direction facing) {
            switch (facing) {
                case NORTH: {
                    switch (this.ordinal()) {
                        case 0: {
                            return Direction.UP;
                        }
                        case 1: {
                            return Direction.DOWN;
                        }
                        case 2: {
                            return Direction.EAST;
                        }
                        case 3: {
                            return Direction.WEST;
                        }
                    }
                }
                case SOUTH: {
                    switch (this.ordinal()) {
                        case 0: {
                            return Direction.UP;
                        }
                        case 1: {
                            return Direction.DOWN;
                        }
                        case 2: {
                            return Direction.WEST;
                        }
                        case 3: {
                            return Direction.EAST;
                        }
                    }
                }
                case EAST: {
                    switch (this.ordinal()) {
                        case 0: {
                            return Direction.UP;
                        }
                        case 1: {
                            return Direction.DOWN;
                        }
                        case 2: {
                            return Direction.SOUTH;
                        }
                        case 3: {
                            return Direction.NORTH;
                        }
                    }
                }
                case WEST: {
                    switch (this.ordinal()) {
                        case 0: {
                            return Direction.UP;
                        }
                        case 1: {
                            return Direction.DOWN;
                        }
                        case 2: {
                            return Direction.NORTH;
                        }
                        case 3: {
                            return Direction.SOUTH;
                        }
                    }
                }
                case UP: {
                    switch (this.ordinal()) {
                        case 0: {
                            return Direction.NORTH;
                        }
                        case 1: {
                            return Direction.SOUTH;
                        }
                        case 2: {
                            return Direction.WEST;
                        }
                        case 3: {
                            return Direction.EAST;
                        }
                    }
                }
                case DOWN: {
                    switch (this.ordinal()) {
                        case 0: {
                            return Direction.SOUTH;
                        }
                        case 1: {
                            return Direction.NORTH;
                        }
                        case 2: {
                            return Direction.WEST;
                        }
                        case 3: {
                            return Direction.EAST;
                        }
                    }
                }
            }
            return Direction.UP;
        }
    }
}

