/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.fluids.ModFluids;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TileEntitySplitTank
extends TileEntityBase
implements ITickableBlockEntity,
IFluidHandler,
Container {
    private int currentMix = 0;
    public int maxMix;
    public int mixUsage;
    private int currentBioDiesel;
    public int maxBioDiesel;
    public int bioDieselGeneration;
    private int currentGlycerin;
    public int maxGlycerin;
    public int glycerinGeneration;
    public int generatingTime;
    private int timeToGenerate;
    protected SimpleContainer inventory;
    public final ContainerData FIELDS = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TileEntitySplitTank.this.currentMix;
                }
                case 1: {
                    return TileEntitySplitTank.this.currentBioDiesel;
                }
                case 2: {
                    return TileEntitySplitTank.this.currentGlycerin;
                }
                case 3: {
                    return TileEntitySplitTank.this.timeToGenerate;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntitySplitTank.this.currentMix = value;
                    break;
                }
                case 1: {
                    TileEntitySplitTank.this.currentBioDiesel = value;
                    break;
                }
                case 2: {
                    TileEntitySplitTank.this.currentGlycerin = value;
                    break;
                }
                case 3: {
                    TileEntitySplitTank.this.timeToGenerate = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public TileEntitySplitTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.SPLIT_TANK_TILE_ENTITY_TYPE.get(), pos, state);
        this.inventory = new SimpleContainer(0);
        this.maxMix = (Integer)Main.SERVER_CONFIG.splitTankFluidStorage.get();
        this.currentBioDiesel = 0;
        this.maxBioDiesel = (Integer)Main.SERVER_CONFIG.splitTankFluidStorage.get();
        this.currentGlycerin = 0;
        this.maxGlycerin = (Integer)Main.SERVER_CONFIG.splitTankFluidStorage.get();
        this.generatingTime = (Integer)Main.SERVER_CONFIG.splitTankGeneratingTime.get();
        this.timeToGenerate = 0;
        this.mixUsage = (Integer)Main.SERVER_CONFIG.splitTankMixUsage.get();
        this.glycerinGeneration = (Integer)Main.SERVER_CONFIG.splitTankGlycerinGeneration.get();
        this.bioDieselGeneration = (Integer)Main.SERVER_CONFIG.splitTankBioDieselGeneration.get();
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        if (this.timeToGenerate > 0) {
            --this.timeToGenerate;
            if (this.timeToGenerate == 0 && this.currentMix - this.mixUsage >= 0) {
                this.currentMix -= this.mixUsage;
                if (this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel) {
                    this.currentBioDiesel += this.bioDieselGeneration;
                }
                if (this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
                    this.currentGlycerin += this.glycerinGeneration;
                }
            }
        } else if (this.currentMix >= this.mixUsage && this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel && this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
            this.timeToGenerate = this.generatingTime;
        }
        if (this.level.getGameTime() % 200L == 0L) {
            this.synchronize();
        }
        this.setChanged();
    }

    public float getBioDieselPerc() {
        return (float)this.currentBioDiesel / (float)this.maxBioDiesel;
    }

    public float getGlycerinPerc() {
        return (float)this.currentGlycerin / (float)this.maxGlycerin;
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("mix", this.currentMix);
        compound.putInt("bio_diesel", this.currentBioDiesel);
        compound.putInt("glycerin", this.currentGlycerin);
        compound.putInt("time", this.timeToGenerate);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.currentMix = compound.getInt("mix");
        this.currentBioDiesel = compound.getInt("bio_diesel");
        this.currentGlycerin = compound.getInt("glycerin");
        this.timeToGenerate = compound.getInt("timeToGenerate");
        super.loadAdditional(compound, provider);
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.inventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.inventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setItem(index, stack);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public void startOpen(Player player) {
        this.inventory.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.inventory.stopOpen(player);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.inventory.canPlaceItem(index, stack);
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public int getCurrentMix() {
        return this.currentMix;
    }

    public int getCurrentBioDiesel() {
        return this.currentBioDiesel;
    }

    public int getCurrentGlycerin() {
        return this.currentGlycerin;
    }

    public int getTimeToGenerate() {
        return this.timeToGenerate;
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.split_tank");
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 3;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank == 0) {
            return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX.get(), this.currentMix);
        }
        if (tank == 1) {
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL.get(), this.currentBioDiesel);
        }
        return new FluidStack((Fluid)ModFluids.GLYCERIN.get(), this.currentGlycerin);
    }

    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.maxMix;
        }
        if (tank == 1) {
            return this.maxBioDiesel;
        }
        return this.maxGlycerin;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank == 0) {
            return stack.getFluid().equals(ModFluids.CANOLA_METHANOL_MIX.get());
        }
        if (tank == 1) {
            return stack.getFluid().equals(ModFluids.BIO_DIESEL.get());
        }
        return stack.getFluid().equals(ModFluids.GLYCERIN.get());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid().equals(ModFluids.CANOLA_METHANOL_MIX.get())) {
            int amount = Math.min(this.maxMix - this.currentMix, resource.getAmount());
            if (action.execute()) {
                this.currentMix += amount;
                this.setChanged();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid().equals(ModFluids.GLYCERIN.get())) {
            int amount = Math.min(resource.getAmount(), this.currentGlycerin);
            if (action.execute()) {
                this.currentGlycerin -= amount;
                this.setChanged();
            }
            return new FluidStack((Fluid)ModFluids.GLYCERIN.get(), amount);
        }
        if (resource.getFluid().equals(ModFluids.BIO_DIESEL.get())) {
            int amount = Math.min(resource.getAmount(), this.currentBioDiesel);
            if (action.execute()) {
                this.currentBioDiesel -= amount;
                this.setChanged();
            }
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL.get(), amount);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.currentGlycerin > this.currentBioDiesel) {
            int amount = Math.min(maxDrain, this.currentGlycerin);
            if (action.execute()) {
                this.currentGlycerin -= amount;
                this.setChanged();
            }
            return new FluidStack((Fluid)ModFluids.GLYCERIN.get(), amount);
        }
        int amount = Math.min(maxDrain, this.currentBioDiesel);
        if (action.execute()) {
            this.currentBioDiesel -= amount;
            this.setChanged();
        }
        return new FluidStack((Fluid)ModFluids.BIO_DIESEL.get(), amount);
    }
}

