/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.energy.EnergyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileEntityDynamo
extends TileEntityBase
implements IEnergyStorage,
ITickableBlockEntity {
    private int storedEnergy;
    public final int maxStorage;
    public final int generation;

    public TileEntityDynamo(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.DYNAMO_TILE_ENTITY_TYPE.get(), pos, state);
        this.maxStorage = (Integer)Main.SERVER_CONFIG.dynamoEnergyStorage.get();
        this.generation = (Integer)Main.SERVER_CONFIG.dynamoEnergyGeneration.get();
        this.storedEnergy = 0;
    }

    @Override
    public void tick() {
        for (Direction side : Direction.values()) {
            IEnergyStorage storage = EnergyUtils.getEnergyStorageOffset(this.level, this.worldPosition, side);
            if (storage == null) continue;
            EnergyUtils.pushEnergy(this, storage, this.storedEnergy);
        }
    }

    public void addEnergy(int energy) {
        this.storedEnergy += energy;
        if (this.storedEnergy > this.maxStorage) {
            this.storedEnergy = this.maxStorage;
        }
        this.setChanged();
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("stored_energy", this.storedEnergy);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.storedEnergy = compound.getInt("stored_energy");
        super.loadAdditional(compound, provider);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int i = Math.min(maxExtract, this.storedEnergy);
        if (!simulate) {
            this.storedEnergy -= i;
            this.setChanged();
        }
        return i;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.dynamo");
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }
}

