/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.ScheduledTask;
import de.mrjulsen.trafficcraft.block.AsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import dev.architectury.networking.NetworkManager;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public class RoadBuilderBuildRoadPacket
extends BaseNetworkPacket<RoadBuilderBuildRoadPacket> {
    private Location pos1;
    private Location pos2;
    private byte roadWidth;
    private boolean replaceBlocks;
    private RoadType roadType;

    public RoadBuilderBuildRoadPacket() {
    }

    public RoadBuilderBuildRoadPacket(Location pos1, Location pos2, byte roadWidth, boolean replaceBlocks, RoadType roadType) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.roadWidth = roadWidth;
        this.replaceBlocks = replaceBlocks;
        this.roadType = roadType;
    }

    public void encode(RoadBuilderBuildRoadPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeNbt((Tag)packet.pos1.toNbt());
        buffer.writeNbt((Tag)packet.pos2.toNbt());
        buffer.writeByte((int)packet.roadWidth);
        buffer.writeBoolean(packet.replaceBlocks);
        buffer.writeEnum((Enum)packet.roadType);
    }

    public RoadBuilderBuildRoadPacket decode(RegistryFriendlyByteBuf buffer) {
        Location pos1 = Location.fromNbt((CompoundTag)buffer.readNbt());
        Location pos2 = Location.fromNbt((CompoundTag)buffer.readNbt());
        byte roadWidth = buffer.readByte();
        boolean replaceBlocks = buffer.readBoolean();
        RoadType roadType = (RoadType)buffer.readEnum(RoadType.class);
        return new RoadBuilderBuildRoadPacket(pos1, pos2, roadWidth, replaceBlocks, roadType);
    }

    public void handle(RoadBuilderBuildRoadPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            Level level = sender.level();
            ItemStack item = null;
            InteractionHand hand = null;
            if (sender.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof RoadConstructionTool) {
                item = sender.getItemInHand(InteractionHand.MAIN_HAND);
                hand = InteractionHand.MAIN_HAND;
            } else if (sender.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof RoadConstructionTool) {
                item = sender.getItemInHand(InteractionHand.OFF_HAND);
                hand = InteractionHand.OFF_HAND;
            } else {
                return;
            }
            RoadConstructionTool.RoadBuildingData buildingData = RoadConstructionTool.prepareRoadBuilding(level, (Player)sender, hand, item, packet.pos1.getLocationVec3(), packet.pos2.getLocationVec3(), packet.roadWidth, packet.replaceBlocks, packet.roadType);
            ScheduledTask.create((Object)buildingData, (Level)level, (int)4, (int)buildingData.blocks.size(), packet::run);
        });
    }

    private boolean run(RoadConstructionTool.RoadBuildingData data, ScheduledTask.ScheduledTaskContext context) {
        ServerLevel serverLevel = (ServerLevel)data.player.level();
        ServerPlayer serverPlayer = (ServerPlayer)data.player;
        boolean[] canContinue = new boolean[]{true};
        for (Map.Entry<BlockPos, Integer> block : data.blocks.get(context.iteration()).entrySet()) {
            if (!canContinue[0] || !data.player.isAlive()) {
                return false;
            }
            if (!RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) && data.player.getInventory().countItem(data.roadType.getSlope().asItem()) <= 0 && data.player.getInventory().countItem(data.roadType.getBlock().asItem()) <= 0) {
                return false;
            }
            if (context.level().getBlockState(block.getKey()).getBlock().defaultDestroyTime() == -1.0f) continue;
            if (block.getValue() > 0 && block.getValue() <= 7 && (RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) || data.player.getInventory().countItem(data.roadType.getSlope().asItem()) > 0)) {
                Optional<ItemStack> stack;
                int countLeft;
                context.level().destroyBlock(block.getKey(), !RoadBuilderBuildRoadPacket.isPlayerCreative(data.player));
                int layers = Math.min(block.getValue(), RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) ? Integer.MAX_VALUE : data.player.getInventory().countItem(data.roadType.getSlope().asItem()));
                context.level().setBlockAndUpdate(block.getKey(), (BlockState)data.roadType.getSlope().defaultBlockState().setValue((Property)AsphaltSlope.LAYERS, (Comparable)Integer.valueOf(layers)));
                if (RoadBuilderBuildRoadPacket.isPlayerCreative(data.player)) continue;
                for (countLeft = layers; canContinue[0] && countLeft > 0 && (stack = data.player.getInventory().items.stream().filter(x -> x.is(data.roadType.getSlope().asItem())).findFirst()).isPresent(); countLeft -= Math.min(countLeft, stack.get().getCount())) {
                    int removeCount = countLeft;
                    stack.get().shrink(removeCount);
                    data.item.hurtAndBreak(1, serverLevel, serverPlayer, item -> {
                        serverPlayer.onEquippedItemBroken(item, data.hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                        canContinue[0] = false;
                    });
                }
                if (countLeft <= 0) continue;
                canContinue[0] = false;
                continue;
            }
            if (block.getValue() <= 7 || !RoadBuilderBuildRoadPacket.isPlayerCreative(data.player) && data.player.getInventory().countItem(data.roadType.getBlock().asItem()) <= 0) continue;
            context.level().destroyBlock(block.getKey(), !RoadBuilderBuildRoadPacket.isPlayerCreative(data.player));
            context.level().setBlockAndUpdate(block.getKey(), data.roadType.getBlock().defaultBlockState());
            if (RoadBuilderBuildRoadPacket.isPlayerCreative(data.player)) continue;
            Optional<ItemStack> stack = data.player.getInventory().items.stream().filter(x -> x.is(data.roadType.getBlock().asItem())).findFirst();
            if (stack.isPresent()) {
                stack.get().shrink(1);
            } else {
                canContinue[0] = false;
            }
            data.item.hurtAndBreak(1, serverLevel, serverPlayer, item -> {
                serverPlayer.onEquippedItemBroken(item, data.hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                canContinue[0] = false;
            });
        }
        if (context.iteration() >= data.blocks.size() - 1) {
            if (context.level().dimension().location().equals((Object)BuiltinDimensionTypes.NETHER.location())) {
                DLUtils.giveAdvancement((ServerPlayer)((ServerPlayer)data.player), (String)"trafficcraft", (String)"highway_to_hell", (String)"req");
            } else if (context.level().dimension().location().equals((Object)BuiltinDimensionTypes.END.location())) {
                DLUtils.giveAdvancement((ServerPlayer)((ServerPlayer)data.player), (String)"trafficcraft", (String)"final_destination", (String)"req");
            }
        }
        return canContinue[0];
    }

    private static boolean isPlayerCreative(Player pPlayer) {
        return pPlayer.isCreative() || pPlayer.isSpectator();
    }
}

