/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.data.StatusResult;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.components.RoadConstructionToolComponent;
import de.mrjulsen.trafficcraft.config.ModCommonConfig;
import de.mrjulsen.trafficcraft.item.IUseDataComponent;
import de.mrjulsen.trafficcraft.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class RoadConstructionTool
extends Item
implements IUseDataComponent<RoadConstructionToolComponent> {
    public static final boolean DEFAULT_REPLACE_BLOCKS = true;
    public static final byte DEFAULT_ROAD_WIDTH = 7;
    public static final RoadType DEFAULT_ROAD_TYPE = RoadType.ASPHALT;
    private static final float ATTACK_DAMAGE_MULTIPLIER = 0.5f;
    private static final int ERROR_TOO_FAR = 1;
    private static final int ERROR_SLOPE_TOO_STEEP = 2;
    public static final int BUILD_DELAY_TICKS = 4;
    private static byte clientTicks;
    private static final byte FAST_GRAPHICS_CLIENT_TICK_DELAY = 8;
    private static final byte FANCY_GRAPHICS_CLIENT_TICK_DELAY = 4;

    public RoadConstructionTool(Tiers tier, Item.Properties properties) {
        super(properties.stacksTo(1).durability(tier.getUses() * 6).attributes(RoadConstructionTool.createAttributes((Tier)tier, (int)(tier.getAttackDamageBonus() * 0.5f), -3.0f)));
    }

    public static int getDefaultRoadWidth() {
        return Math.min(7, (Integer)ModCommonConfig.ROAD_BUILDER_MAX_ROAD_WIDTH.get());
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos clickedPos = pContext.getClickedPos();
        Vec3 clickedVec = pContext.getClickLocation();
        Player player = pContext.getPlayer();
        ItemStack stack = pContext.getItemInHand();
        if (!player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                RoadConstructionToolComponent comp = (RoadConstructionToolComponent)this.getComponent(stack);
                Location location = new Location((double)clickedPos.getX(), clickedVec.y, (double)clickedPos.getZ(), level.dimension().location().toString());
                Optional<Location> startLoc = comp.start();
                Optional<Location> endLoc = comp.end();
                if (startLoc.isPresent()) {
                    if (RoadConstructionTool.isLineValid(comp.start().get().getLocationVec3(), location.getLocationVec3()).result()) {
                        endLoc = Optional.of(location);
                    }
                } else {
                    startLoc = Optional.of(location);
                }
                this.setComponent(stack, new RoadConstructionToolComponent(startLoc, endLoc, comp.type(), comp.roadWidth(), comp.replaceBlocks()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(pContext);
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, int attackDamage, float attackSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)((float)attackDamage + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean isFoil(ItemStack pStack) {
        if (!this.hasComponent(pStack)) {
            return false;
        }
        RoadConstructionToolComponent comp = (RoadConstructionToolComponent)this.getComponent(pStack);
        return comp != null && (comp.start().isPresent() || comp.end().isPresent()) || super.isFoil(pStack);
    }

    public static void reset(ItemStack stack) {
        stack.remove((DataComponentType)ModDataComponents.ROAD_CONSTRUCTION_TOOL_COMPONENT.get());
    }

    private static StatusResult isLineValid(Vec3 a, Vec3 b) {
        boolean flag1 = a.distanceTo(b) < (double)((Integer)ModCommonConfig.ROAD_BUILDER_MAX_DISTANCE.get()).intValue();
        boolean flag2 = MathUtils.slope((Vec3)a, (Vec3)b) >= (Double)ModCommonConfig.ROAD_BUILDER_MAX_SLOPE.get();
        int status = 0;
        if (!flag1) {
            status = 1;
        } else if (!flag2) {
            status = 2;
        }
        return new StatusResult(flag1 && flag2, status, null);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pUsedHand);
        RoadConstructionToolComponent comp = (RoadConstructionToolComponent)this.getComponent(itemstack);
        Optional<Location> startLoc = comp.start();
        Optional<Location> endLoc = comp.end();
        Collection<Object> blockList = new ArrayList();
        if (endLoc.isPresent() && startLoc.isPresent()) {
            Vec3 start = startLoc.get().getLocationVec3();
            Vec3 end = endLoc.get().getLocationVec3();
            byte roadWidth = comp.roadWidth();
            boolean replaceBlocks = comp.replaceBlocks();
            blockList = RoadConstructionTool.calculateRoad(pLevel, start, end, roadWidth, replaceBlocks);
        }
        if (pLevel.isClientSide) {
            ClientWrapper.showRoadConstructionToolScreen(itemstack, (int)blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v <= 0 || v >= 8).count(), blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v > 0 && v < 8).mapToInt(x -> x).sum());
        }
        return InteractionResultHolder.success((Object)itemstack);
    }

    public static RoadBuilderCountResult countBlocksNeeded(Level level, Vec3 start, Vec3 end, byte roadWidth, boolean replaceBlocks) {
        Collection<Object> blockList = new ArrayList();
        blockList = RoadConstructionTool.calculateRoad(level, start, end, roadWidth, replaceBlocks);
        return new RoadBuilderCountResult((int)blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v <= 0 || v >= 8).count(), blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v > 0 && v < 8).mapToInt(x -> x).sum());
    }

    public static Collection<Map<BlockPos, Integer>> calculateRoad(Level level, Vec3 start, Vec3 end, byte roadWidth, boolean replaceBlocks) {
        double spacingMul = 2.0;
        if (start.y > end.y) {
            Vec3 temp = end;
            end = start;
            start = temp;
        }
        Vec3 vec = new Vec3(end.x, end.y, end.z).subtract(start);
        Vec3 rVec = new Vec3(vec.z, 0.0, -vec.x).normalize();
        double lastY = Double.MIN_VALUE;
        ArrayList<Map<BlockPos, Integer>> blockList = new ArrayList<Map<BlockPos, Integer>>();
        int i = 0;
        while ((double)i <= vec.length() * 2.0) {
            double d;
            double a = d = 1.0 / vec.length() / 2.0 * (double)i;
            HashMap<BlockPos, Integer> blockLayer = new HashMap<BlockPos, Integer>();
            Vec3 vecPos = new Vec3(vec.x * a, vec.y * a, vec.z * a).add(start);
            Vec3 rightVec = i == 0 ? rVec.normalize() : new Vec3(vec.z * a, 0.0, -(vec.x * a)).normalize();
            lastY = RoadConstructionTool.setLayer(level, lastY, vecPos, rightVec, blockLayer, roadWidth, replaceBlocks);
            blockList.forEach(x -> x.entrySet().removeIf(y -> blockLayer.keySet().stream().anyMatch(z -> ((BlockPos)y.getKey()).equals(z))));
            blockList.add(blockLayer);
            ++i;
        }
        return blockList;
    }

    public static RoadBuildingData prepareRoadBuilding(Level pLevel, Player pPlayer, InteractionHand pHand, ItemStack pStack, Vec3 start, Vec3 end, byte roadWidth, boolean replaceBlocks, RoadType roadType) {
        Collection<Map<BlockPos, Integer>> blockList = RoadConstructionTool.calculateRoad(pLevel, start, end, roadWidth, replaceBlocks);
        pPlayer.getCooldowns().addCooldown(pStack.getItem(), blockList.size() * 4);
        if (!pLevel.isClientSide) {
            DLUtils.giveAdvancement((ServerPlayer)((ServerPlayer)pPlayer), (String)"trafficcraft", (String)"road_construction_tool", (String)"req");
        }
        return new RoadBuildingData(blockList, pPlayer, pHand, pStack, start, end, roadWidth, replaceBlocks, roadType);
    }

    private static double setLayer(Level pLevel, double lastY, Vec3 pos, Vec3 normalizedRightVec, Map<BlockPos, Integer> blockList, byte roadWidth, boolean replaceBlocks) {
        block8: {
            BlockPos bPos;
            Vec3 vec;
            double i;
            double height;
            double halfWidth;
            block7: {
                halfWidth = (double)roadWidth / 2.0 - 0.5;
                double step = 0.5;
                double pixel = 0.0625;
                double slopeHeight = 0.125;
                double d = pos.y < 0.0 ? pos.y - (double)((int)pos.y) + (double)(!(Math.abs(pos.y - (double)((int)pos.y)) <= 0.0) ? 1 : 0) : (height = pos.y - (double)((int)pos.y));
                if (lastY < (double)((int)pos.y) + 0.125) {
                    for (i = -halfWidth; i < halfWidth + 0.5; i += 0.5) {
                        vec = pos.add(normalizedRightVec.scale(i));
                        bPos = new BlockPos((int)vec.x, (int)vec.y - 1, (int)vec.z);
                        if (!replaceBlocks && !pLevel.isEmptyBlock(bPos)) continue;
                        if (blockList.containsKey(bPos)) {
                            blockList.remove(bPos);
                        }
                        blockList.put(bPos, 8);
                    }
                }
                if (!(height >= 1.0625)) break block7;
                for (i = -halfWidth; i < halfWidth + 0.5; i += 0.5) {
                    vec = pos.add(normalizedRightVec.scale(i));
                    bPos = new BlockPos((int)vec.x, (int)vec.y, (int)vec.z);
                    if (!replaceBlocks && !pLevel.isEmptyBlock(bPos)) continue;
                    if (blockList.containsKey(bPos)) {
                        blockList.remove(bPos);
                    }
                    blockList.put(bPos, 8);
                }
                break block8;
            }
            if (!(height >= 0.125)) break block8;
            for (i = -halfWidth; i < halfWidth + 0.5; i += 0.5) {
                vec = pos.add(normalizedRightVec.scale(i));
                bPos = new BlockPos((int)vec.x, (int)vec.y, (int)vec.z);
                if (!replaceBlocks && !pLevel.isEmptyBlock(bPos)) continue;
                if (blockList.containsKey(bPos)) {
                    blockList.remove(bPos);
                }
                blockList.put(bPos, (int)(height / 0.125));
            }
        }
        return pos.y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        RoadConstructionTool item;
        if ((clientTicks = (byte)(clientTicks + 1)) > (Minecraft.useFancyGraphics() ? (byte)4 : 8)) {
            clientTicks = 0;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (player == null || level == null) {
            return;
        }
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        if (!(player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof RoadConstructionTool) && !(player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof RoadConstructionTool)) {
            return;
        }
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof RoadConstructionTool ? player.getItemInHand(InteractionHand.MAIN_HAND) : player.getItemInHand(InteractionHand.OFF_HAND);
        Item item2 = stack.getItem();
        if (!(item2 instanceof RoadConstructionTool) || !(item = (RoadConstructionTool)item2).hasComponent(stack)) {
            return;
        }
        RoadConstructionToolComponent comp = (RoadConstructionToolComponent)item.getComponent(stack);
        if (!comp.start().isPresent()) {
            return;
        }
        Vec3 start = comp.start().get().getLocationVec3().add(0.5, 0.0, 0.5);
        Vec3 end = null;
        if (comp.start().isPresent() && !comp.end().isPresent()) {
            HitResult lookingAt = player.pick(4.5, 0.0f, false);
            Vec3 lookAtVec = lookingAt.getLocation();
            if (!level.isEmptyBlock(new BlockPos((int)lookAtVec.x, (int)lookAtVec.y, (int)lookAtVec.z)) || !level.isEmptyBlock(new BlockPos((int)lookAtVec.x, (int)(lookAtVec.y - 0.5), (int)lookAtVec.z))) {
                double blockHeight = level.getBlockFloorHeight(new BlockPos((int)lookAtVec.x, (int)lookAtVec.y, (int)lookAtVec.z));
                int vX = lookAtVec.x() > 0.0 ? 1 : -1;
                int vZ = lookAtVec.z() > 0.0 ? 1 : -1;
                end = new Vec3((double)((int)lookAtVec.x()) + (double)vX * 0.5, (double)((int)lookAtVec.y()) + (blockHeight <= 0.0 ? 0.0 : blockHeight), (double)((int)lookAtVec.z()) + (double)vZ * 0.5);
            } else {
                end = null;
            }
            player.displayClientMessage((Component)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_pos1", (Object[])new Object[]{comp.start().get().getLocationBlockPos().toShortString()}), true);
        } else if (comp.start().isPresent() && comp.end().isPresent()) {
            end = comp.end().get().getLocationVec3().add(0.5, 0.0, 0.5);
            player.displayClientMessage((Component)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_pos2", (Object[])new Object[]{comp.start().get().getLocationBlockPos().toShortString(), comp.end().get().getLocationBlockPos().toShortString()}).withStyle(ChatFormatting.GREEN), true);
        }
        if (end == null) {
            return;
        }
        Vec3 line = end.subtract(start);
        double width = comp.roadWidth();
        double halfWidth = width / 2.0;
        double spacing = 0.25;
        if (line.length() <= 0.0) {
            return;
        }
        if (line.length() < 256.0) {
            double mul = 1.0 / Math.min(line.length(), 256.0) * 0.25;
            int lineStatus = RoadConstructionTool.isLineValid(start, end).code();
            switch (lineStatus) {
                case 1: {
                    player.displayClientMessage((Component)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_too_far").withStyle(ChatFormatting.RED), true);
                    break;
                }
                case 2: {
                    player.displayClientMessage((Component)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_slope_too_steep").withStyle(ChatFormatting.RED), true);
                    break;
                }
            }
            if (clientTicks == 0) {
                for (double d = 0.0; d < 1.0; d += mul) {
                    Vec3 vecPos = new Vec3(line.x * d, line.y * d, line.z * d).add(start);
                    level.addParticle((ParticleOptions)new DustParticleOptions(RoadConstructionTool.isLineValid(start, end).result() ? new Vector3f(0.2f, 0.9f, 0.2f) : new Vector3f(0.9f, 0.2f, 0.2f), 1.0f), vecPos.x, vecPos.y, vecPos.z, 0.0, 0.0, 0.0);
                    Vec3 rightVec = vecPos.add(new Vec3(line.z * d, 0.0, -line.x * d).normalize().scale(halfWidth));
                    level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.6f), 0.5f), rightVec.x, rightVec.y, rightVec.z, 0.0, 0.0, 0.0);
                    Vec3 leftVec = vecPos.add(new Vec3(-line.z * d, 0.0, line.x * d).normalize().scale(halfWidth));
                    level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.6f), 0.5f), leftVec.x, leftVec.y, leftVec.z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public DataComponentType<RoadConstructionToolComponent> getComponentType() {
        return (DataComponentType)ModDataComponents.ROAD_CONSTRUCTION_TOOL_COMPONENT.get();
    }

    @Override
    public RoadConstructionToolComponent emptyComponent() {
        return RoadConstructionToolComponent.empty();
    }

    public static class RoadBuilderCountResult {
        public final int blocksCount;
        public final int slopesCount;

        protected RoadBuilderCountResult(int blocksCount, int slopesCount) {
            this.blocksCount = blocksCount;
            this.slopesCount = slopesCount;
        }
    }

    public static class RoadBuildingData {
        public final List<Map<BlockPos, Integer>> blocks;
        public final Player player;
        public final InteractionHand hand;
        public final ItemStack item;
        public final Vec3 start;
        public final Vec3 end;
        public final byte roadWidth;
        public final boolean replaceBlocks;
        public final RoadType roadType;

        public RoadBuildingData(Collection<Map<BlockPos, Integer>> blocks, Player player, InteractionHand hand, ItemStack item, Vec3 start, Vec3 end, byte roadWidth, boolean replaceBlocks, RoadType roadType) {
            this.blocks = new ArrayList<Map<BlockPos, Integer>>(blocks);
            this.player = player;
            this.hand = hand;
            this.item = item;
            this.start = start;
            this.end = end;
            this.roadWidth = roadWidth;
            this.replaceBlocks = replaceBlocks;
            this.roadType = roadType;
        }
    }
}

