/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.client.tooltip.TrafficSignTooltip;
import de.mrjulsen.trafficcraft.components.PatternCatalogueComponent;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.item.IUseDataComponent;
import de.mrjulsen.trafficcraft.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PatternCatalogueItem
extends Item
implements IUseDataComponent<PatternCatalogueComponent> {
    private static final int MAX_SIGN_PATTERNS = 36;
    private static final Map<ItemStack, Optional<TooltipComponent>> tooltips = new HashMap<ItemStack, Optional<TooltipComponent>>();

    public PatternCatalogueItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            ClientWrapper.showSignPatternSelectionScreen(stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public int getMaxPatterns() {
        return 36;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        Optional tooltip = tooltips.computeIfAbsent(pStack, x -> this.createTooltip((ItemStack)x));
        tooltip.ifPresent(x -> ((TrafficSignTooltip)x).initAgeable());
        return tooltip;
    }

    private Optional<TooltipComponent> createTooltip(ItemStack stck) {
        ItemStack stack = stck;
        NonNullList nonnulllist = NonNullList.create();
        if (this.hasComponent(stack)) {
            Arrays.stream(this.getStoredPatterns(stack)).forEach(arg_0 -> nonnulllist.add(arg_0));
        }
        return Optional.of(new TrafficSignTooltip((NonNullList<NamedTrafficSignTextureReference>)nonnulllist, this.getSelectedImageData(stack), this.getSelectedIndex(stack), () -> {
            if (tooltips.containsKey(stack)) {
                tooltips.remove(stack);
            }
        }));
    }

    public NamedTrafficSignTextureReference getSelectedImageData(ItemStack stack) {
        return this.getSelectedPattern(stack);
    }

    protected boolean indexInBounds(ItemStack stack, int index) {
        return index >= 0 && index < this.getStoredPatternCount(stack);
    }

    public int getSelectedIndex(ItemStack stack) {
        return ((PatternCatalogueComponent)this.getComponent(stack)).selectedIndex();
    }

    public short getStoredPatternCount(ItemStack stack) {
        return (short)((PatternCatalogueComponent)this.getComponent(stack)).textures().size();
    }

    public NamedTrafficSignTextureReference getPatternAt(ItemStack stack, int index) {
        if (!this.indexInBounds(stack, index)) {
            return null;
        }
        return ((PatternCatalogueComponent)this.getComponent(stack)).textures().get(index);
    }

    public NamedTrafficSignTextureReference getSelectedPattern(ItemStack stack) {
        return this.getPatternAt(stack, ((PatternCatalogueComponent)this.getComponent(stack)).selectedIndex());
    }

    public NamedTrafficSignTextureReference[] getStoredPatterns(ItemStack stack) {
        return (NamedTrafficSignTextureReference[])((PatternCatalogueComponent)this.getComponent(stack)).textures().toArray(NamedTrafficSignTextureReference[]::new);
    }

    public boolean setPattern(ItemStack stack, NamedTrafficSignTextureReference pattern) {
        if (this.getStoredPatternCount(stack) >= ((PatternCatalogueItem)stack.getItem()).getMaxPatterns()) {
            return false;
        }
        PatternCatalogueComponent comp = (PatternCatalogueComponent)this.getComponent(stack);
        List<NamedTrafficSignTextureReference> textures = comp.textures();
        textures.add(pattern);
        this.setComponent(stack, new PatternCatalogueComponent(textures, textures.size() - 1));
        return true;
    }

    public boolean replacePattern(ItemStack stack, NamedTrafficSignTextureReference pattern, int index) {
        if (this.getStoredPatternCount(stack) >= ((PatternCatalogueItem)stack.getItem()).getMaxPatterns()) {
            return false;
        }
        PatternCatalogueComponent comp = (PatternCatalogueComponent)this.getComponent(stack);
        List<NamedTrafficSignTextureReference> textures = comp.textures();
        textures.set(index, pattern);
        this.setComponent(stack, new PatternCatalogueComponent(textures, index));
        return true;
    }

    public boolean removePatternAt(ItemStack stack, int index) {
        if (!this.indexInBounds(stack, index)) {
            return false;
        }
        PatternCatalogueComponent comp = (PatternCatalogueComponent)this.getComponent(stack);
        List<NamedTrafficSignTextureReference> textures = comp.textures();
        textures.remove(index);
        int newIndex = index;
        if (newIndex >= textures.size()) {
            newIndex = Math.max(0, textures.size() - 1);
        }
        this.setComponent(stack, new PatternCatalogueComponent(textures, textures.size() - 1));
        return true;
    }

    public void clearPatterns(ItemStack stack) {
        this.setComponent(stack, new PatternCatalogueComponent(new ArrayList<NamedTrafficSignTextureReference>(), 0));
    }

    public void setSelectedIndex(ItemStack stack, int index) {
        PatternCatalogueComponent comp = (PatternCatalogueComponent)this.getComponent(stack);
        this.setComponent(stack, new PatternCatalogueComponent(comp.textures(), Mth.clamp((int)index, (int)-1, (int)Math.max(0, this.getStoredPatternCount(stack) - 1))));
    }

    @Override
    public DataComponentType<PatternCatalogueComponent> getComponentType() {
        return (DataComponentType)ModDataComponents.PATTERN_CATALOGUE_COMPONENT.get();
    }

    @Override
    public PatternCatalogueComponent emptyComponent() {
        return PatternCatalogueComponent.empty();
    }
}

