/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.trafficcraft.recipe.IDamageableCraftingItem;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class HammerItem
extends DiggerItem
implements IDamageableCraftingItem {
    public HammerItem(Item.Properties properties) {
        super((Tier)Tiers.IRON, BlockTags.MINEABLE_WITH_PICKAXE, properties.stacksTo(1).durability(Tiers.IRON.getUses()).attributes(PickaxeItem.createAttributes((Tier)Tiers.IRON, (float)1.0f, (float)-2.8f)));
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos pos;
        Level level = pContext.getLevel();
        BlockState block = level.getBlockState(pos = pContext.getClickedPos());
        if (block.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            if (DLUtils.rotateBlock((Level)level, (BlockPos)pos, (Rotation)Rotation.CLOCKWISE_90)) {
                level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ANVIL_PLACE, SoundSource.BLOCKS, 0.5f, 2.0f, false);
                level.levelEvent(pContext.getPlayer(), 3005, pos, Block.getId((BlockState)pContext.getLevel().getBlockState(pContext.getClickedPos())));
                pContext.getPlayer().getCooldowns().addCooldown(pContext.getItemInHand().getItem(), 10);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(pContext);
    }
}

