/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.core.ColorObject;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.item.IUseDataComponent;
import de.mrjulsen.trafficcraft.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ColorPaletteItem
extends Item
implements IUseDataComponent<List<Integer>> {
    public static final int MAX_COLORS = 7;
    public static final String COLORS_TAG = "colors";

    public ColorPaletteItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Item item = stack.getItem();
        if (!(item instanceof ColorPaletteItem)) {
            return;
        }
        ColorPaletteItem item2 = (ColorPaletteItem)item;
        if (!item2.hasComponent(stack)) {
            tooltipComponents.add((Component)TextUtils.translate((String)"item.trafficcraft.color_palette.no_color").withStyle(ChatFormatting.GRAY));
            return;
        }
        List colors = (List)item2.getComponent(stack);
        if (!colors.stream().anyMatch(x -> x != 0)) {
            tooltipComponents.add((Component)TextUtils.translate((String)"item.trafficcraft.color_palette.no_color").withStyle(ChatFormatting.GRAY));
        } else {
            Iterator iterator = colors.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i == 0) {
                    tooltipComponents.add((Component)TextUtils.translate((String)"item.trafficcraft.color_palette.color_unset").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    continue;
                }
                ColorObject c = ColorObject.fromInt((int)i);
                tooltipComponents.add((Component)TextUtils.text((String)String.format("\u2b1b  %s, %s, %s (#%s)", c.getR(), c.getG(), c.getB(), Integer.toHexString(i).toUpperCase())).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)i))));
            }
        }
    }

    public static int getColorAt(ItemStack stack, int index) {
        Item item = stack.getItem();
        if (!(item instanceof ColorPaletteItem)) {
            return 0;
        }
        ColorPaletteItem item2 = (ColorPaletteItem)item;
        if (!item2.hasComponent(stack)) {
            return 0;
        }
        if (index < 0 || index >= 7) {
            return 0;
        }
        return (Integer)((List)item2.getComponent(stack)).get(index);
    }

    public static boolean setColor(ItemStack stack, int index, int color) {
        Item item = stack.getItem();
        if (!(item instanceof ColorPaletteItem)) {
            return false;
        }
        ColorPaletteItem item2 = (ColorPaletteItem)item;
        if (index < 0 || index >= 7) {
            return false;
        }
        ArrayList<Integer> colors = new ArrayList<Integer>((Collection)item2.getComponent(stack));
        colors.set(index, color);
        item2.setComponent(stack, colors);
        return true;
    }

    @Override
    public DataComponentType<List<Integer>> getComponentType() {
        return (DataComponentType)ModDataComponents.COLOR_PALETTE_COMPONENT.get();
    }

    @Override
    public List<Integer> emptyComponent() {
        ArrayList<Integer> list = new ArrayList<Integer>(7);
        for (int i = 0; i < 7; ++i) {
            list.add(0);
        }
        return list;
    }
}

