/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.PaintBucketBlock;
import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.block.data.IPaintableBlock;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.components.BrushComponent;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.item.IUseDataComponent;
import de.mrjulsen.trafficcraft.registry.ModDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BrushItem
extends Item
implements IUseDataComponent<BrushComponent> {
    private int paintAmount = 0;

    public BrushItem(Item.Properties properties, int paintAmount) {
        super(properties.stacksTo(1));
        this.paintAmount = paintAmount;
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        Block block;
        if (player.isCreative() && (block = state.getBlock()) instanceof IPaintableBlock) {
            IPaintableBlock block2 = (IPaintableBlock)block;
            block2.onRemoveColor(state, worldIn, pos, player);
            return false;
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            BrushComponent comp = (BrushComponent)this.getComponent(stack);
            ClientWrapper.showPaintBrushScreen(comp.patternId(), comp.paintAmount(), PaintColor.getByIndex(comp.colorId()));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.hasComponent(stack)) {
            BrushComponent comp = (BrushComponent)this.getComponent(stack);
            PaintColor paintColor = PaintColor.getByIndex(comp.colorId());
            String color = TextUtils.translate((String)paintColor.getValueTranslationKey("trafficcraft")).getString();
            tooltipComponents.add((Component)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.pattern", (Object[])new Object[]{"\u00a7f" + comp.patternId()}).withStyle(ChatFormatting.GRAY));
            if (comp.paintAmount() == 0) {
                tooltipComponents.add((Component)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color", (Object[])new Object[]{TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color_empty")}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltipComponents.add((Component)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color", (Object[])new Object[]{TextUtils.text((String)color).withStyle(Style.EMPTY.applyFormat(ChatFormatting.WHITE).withColor(paintColor.getTextureColor()))}).withStyle(ChatFormatting.GRAY));
            }
            tooltipComponents.add((Component)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.paint", (Object[])new Object[]{"\u00a7f" + (int)(0.78125f * (float)comp.paintAmount())}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.hasComponent(stack) && ((BrushComponent)this.getComponent(stack)).paintAmount() > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return this.hasComponent(stack) ? ((BrushComponent)this.getComponent(stack)).paintAmount() * 13 / 128 : 0;
    }

    public int getBarColor(ItemStack pStack) {
        return this.hasComponent(pStack) ? this.getColor(pStack).getTextureColor() : 0;
    }

    public int getPaintAmount() {
        return this.paintAmount;
    }

    public PaintColor getColor(ItemStack stack) {
        return PaintColor.getByIndex(((BrushComponent)this.getComponent(stack)).colorId());
    }

    public int getPatternId(ItemStack stack) {
        return ((BrushComponent)this.getComponent(stack)).patternId();
    }

    public int getPaint(ItemStack stack) {
        return ((BrushComponent)this.getComponent(stack)).paintAmount();
    }

    public int getMaxPaint() {
        return 128;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        ItemStack stack = pContext.getItemInHand();
        if (!this.hasComponent(stack)) {
            return InteractionResult.FAIL;
        }
        BrushComponent comp = (BrushComponent)this.getComponent(stack);
        if (comp.paintAmount() <= 0) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = pContext.getClickedPos();
        BlockState state = pContext.getLevel().getBlockState(pos);
        Player player = pContext.getPlayer();
        if (state.getBlock() instanceof PaintBucketBlock) {
            level.playSound(null, pos, SoundEvents.BUCKET_FILL_LAVA, SoundSource.BLOCKS, 0.8f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        Block block = state.getBlock();
        if (block instanceof IPaintableBlock) {
            IColorBlockEntity blockEntity;
            IPaintableBlock block2 = (IPaintableBlock)block;
            BlockEntity blockEntity2 = level.getBlockEntity(pos);
            if (blockEntity2 instanceof IColorBlockEntity && (blockEntity = (IColorBlockEntity)blockEntity2).getColor() == PaintColor.getByIndex(comp.colorId())) {
                InteractionResult res = block2.update(pContext);
                if (res == InteractionResult.CONSUME) {
                    this.removePaint(player, stack, comp);
                    res = InteractionResult.SUCCESS;
                }
                return res;
            }
            InteractionResult res = block2.onSetColor(pContext);
            if (res == InteractionResult.CONSUME) {
                this.removePaint(player, stack, comp);
                res = InteractionResult.SUCCESS;
            }
            return res;
        }
        return InteractionResult.PASS;
    }

    private void removePaint(Player player, ItemStack stack, BrushComponent component) {
        if (!player.isCreative()) {
            stack.set((DataComponentType)ModDataComponents.BRUSH_COMPONENT.get(), (Object)new BrushComponent(component.patternId(), component.paintAmount() - 1, component.colorId()));
        }
    }

    @Override
    public DataComponentType<BrushComponent> getComponentType() {
        return (DataComponentType)ModDataComponents.BRUSH_COMPONENT.get();
    }

    @Override
    public BrushComponent emptyComponent() {
        return BrushComponent.empty();
    }
}

