/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLItemButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLSlider;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.components.RoadConstructionToolComponent;
import de.mrjulsen.trafficcraft.config.ModCommonConfig;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import de.mrjulsen.trafficcraft.network.packets.cts.RoadBuilderBuildRoadPacket;
import de.mrjulsen.trafficcraft.network.packets.cts.RoadBuilderDataPacket;
import de.mrjulsen.trafficcraft.network.packets.cts.RoadBuilderResetPacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RoadConstructionToolScreen
extends DLScreen {
    public static final Component title = TextUtils.translate((String)"gui.trafficcraft.road_builder.title");
    private static final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)"textures/gui/road_construction_tool.png");
    private static final int GUI_WIDTH = 244;
    private static final int GUI_HEIGHT = 179;
    private static final int WORKING_AREA_X = 7;
    private static final int WORKING_AREA_Y = 17;
    private static final int WORKING_AREA_WIDTH = 230;
    private static final int WORKING_AREA_HEIGHT = 155;
    private static final int WORKING_AREA_BOTTOM = 172;
    private static final int WORKING_AREA_RIGHT = 237;
    private int guiTop;
    private int guiLeft;
    private final WidgetsCollection itemButtonCollection = new WidgetsCollection();
    private DLSlider widthSlider;
    private DLButton buildButton;
    private GuiAreaDefinition pos1Area;
    private GuiAreaDefinition pos2Area;
    private GuiAreaDefinition buildButtonArea;
    private byte roadWidth;
    private boolean replaceExistingBlocks;
    private RoadType roadType = RoadType.ASPHALT;
    private final ItemStack stack;
    private final Location pos1;
    private final Location pos2;
    private int blocksCount;
    private int slopesCount;
    private final Component resetText = TextUtils.translate((String)"gui.trafficcraft.road_builder.reset");
    private final Component buildText = TextUtils.translate((String)"gui.trafficcraft.road_builder.build").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD);
    private final Component replaceBlocksText = TextUtils.translate((String)"gui.trafficcraft.road_builder.replace_blocks");
    private final Component roadWidthText = TextUtils.translate((String)"gui.trafficcraft.road_builder.road_width");
    private final Component roadBlocksText = TextUtils.translate((String)"gui.trafficcraft.road_builder.road_blocks");
    private final Component requiredResourcesText = TextUtils.translate((String)"gui.trafficcraft.road_builder.required_resources");
    private final Component noPositionDefined = TextUtils.translate((String)"gui.trafficcraft.road_builder.no_pos_defined");
    private final Component tooltipPos1 = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.pos1");
    private final Component tooltipPos2 = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.pos2");
    private final Component tooltipReplaceBlocks = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.replace_blocks");
    private final Component tooltipReset = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.reset");
    private final Component tooltipBuild = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.build");
    private final Component tooltipBuildMissingPos = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.build_missing_pos");

    public RoadConstructionToolScreen(ItemStack stack, int blocksCount, int slopesCount) {
        super(title);
        Item item = stack.getItem();
        if (!(item instanceof RoadConstructionTool)) {
            throw new IllegalArgumentException(stack.getDisplayName().getString() + " is not a valid item for screen 'RoadBuilderToolScreen'.");
        }
        RoadConstructionTool item2 = (RoadConstructionTool)item;
        RoadConstructionToolComponent comp = (RoadConstructionToolComponent)item2.getComponent(stack);
        this.pos1 = comp.start().orElse(null);
        this.pos2 = comp.end().orElse(null);
        this.roadWidth = comp.roadWidth();
        this.replaceExistingBlocks = comp.replaceBlocks();
        this.roadType = comp.type();
        this.stack = stack;
        this.blocksCount = blocksCount;
        this.slopesCount = slopesCount;
    }

    public void init() {
        super.init();
        this.guiLeft = this.width / 2 - 122;
        this.guiTop = this.height / 2 - 89;
        this.itemButtonCollection.components.clear();
        this.pos1Area = new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 17, 114, 18);
        this.pos2Area = new GuiAreaDefinition(this.guiLeft + 123, this.guiTop + 17, 114, 18);
        int btnSpace = 76;
        int btnWidth = btnSpace - 2;
        this.addButton(this.guiLeft + 7 + btnSpace * 0, this.guiTop + 172 - 20, btnWidth, 20, this.resetText, p -> {
            DLNetworkManager.sendToServer((BaseNetworkPacket)new RoadBuilderResetPacket());
            this.onClose();
        }, DLTooltip.of((FormattedText)this.tooltipReset).withMaxWidth(this.width / 4));
        this.buildButton = this.addButton(this.guiLeft + 7 + btnSpace * 1 + 2, this.guiTop + 172 - 20, btnWidth, 20, this.buildText, p -> {
            this.updateStackData();
            RoadConstructionTool item = (RoadConstructionTool)this.stack.getItem();
            RoadConstructionToolComponent comp = (RoadConstructionToolComponent)item.getComponent(this.stack);
            Location pos1 = comp.start().get();
            Location pos2 = comp.end().get();
            byte roadWidth = comp.roadWidth();
            boolean replaceBlocks = comp.replaceBlocks();
            RoadType roadType = comp.type();
            DLNetworkManager.sendToServer((BaseNetworkPacket)new RoadBuilderBuildRoadPacket(pos1, pos2, roadWidth, replaceBlocks, roadType));
            RoadConstructionTool.reset(this.stack);
            DLNetworkManager.sendToServer((BaseNetworkPacket)new RoadBuilderResetPacket());
            this.onDone();
        }, null);
        this.buildButton.active = this.pos1 != null && this.pos2 != null && this.roadWidth > 0;
        this.buildButtonArea = new GuiAreaDefinition(this.buildButton.x(), this.buildButton.y(), this.buildButton.getWidth(), this.buildButton.getHeight());
        this.addButton(this.guiLeft + 7 + btnSpace * 2 + 4, this.guiTop + 172 - 20, btnWidth, 20, CommonComponents.GUI_DONE, p -> this.onDone(), null);
        this.addOnOffButton(this.guiLeft + 7, this.guiTop + 38, 114, 20, this.replaceBlocksText, this.replaceExistingBlocks, (btn, value) -> {
            this.replaceExistingBlocks = value;
            if (this.pos1 != null && this.pos2 != null) {
                RoadConstructionTool.RoadBuilderCountResult res = RoadConstructionTool.countBlocksNeeded((Level)this.minecraft.level, this.pos1.getLocationVec3(), this.pos2.getLocationVec3(), this.roadWidth, this.replaceExistingBlocks);
                this.blocksCount = res.blocksCount;
                this.slopesCount = res.slopesCount;
            }
        }, DLTooltip.of((FormattedText)this.tooltipReplaceBlocks).withMaxWidth(this.width / 4));
        this.widthSlider = this.addSlider(this.guiLeft + 7 + 116, this.guiTop + 38, 114, 20, this.roadWidthText, (Component)TextUtils.text((String)""), 1.0, ((Integer)ModCommonConfig.ROAD_BUILDER_MAX_ROAD_WIDTH.get()).intValue(), 1.0, this.roadWidth, true, (slider, value) -> {
            this.roadWidth = value.byteValue();
            if (this.pos1 != null && this.pos2 != null) {
                RoadConstructionTool.RoadBuilderCountResult res = RoadConstructionTool.countBlocksNeeded((Level)this.minecraft.level, this.pos1.getLocationVec3(), this.pos2.getLocationVec3(), this.roadWidth, this.replaceExistingBlocks);
                this.blocksCount = res.blocksCount;
                this.slopesCount = res.slopesCount;
            }
        }, null, null);
        int blocksWidth = 228;
        int buttonWidth = blocksWidth / (RoadType.values().length - 1);
        for (int i = 1; i < RoadType.values().length; ++i) {
            RoadType type = RoadType.values()[i];
            DLItemButton btn2 = (DLItemButton)this.addRenderableWidget((GuiEventListener)((DLItemButton)new DLItemButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, new ItemStack((ItemLike)type.getBlock().asItem()), this.itemButtonCollection, this.guiLeft + 7 + 1 + buttonWidth * (i - 1), this.guiTop + 84, buttonWidth, 18, null, p -> {
                this.roadType = type;
            }).withAlignment(EAlignment.LEFT)));
            if (type != this.roadType) continue;
            btn2.select();
        }
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipPos1).assignedTo(this.pos1Area));
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipPos2).assignedTo(this.pos2Area));
    }

    private void updateStackData() {
        this.roadWidth = (byte)this.widthSlider.getValue();
        Item item = this.stack.getItem();
        if (!(item instanceof RoadConstructionTool)) {
            return;
        }
        RoadConstructionTool item2 = (RoadConstructionTool)item;
        RoadConstructionToolComponent comp = (RoadConstructionToolComponent)item2.getComponent(this.stack);
        item2.setComponent(this.stack, new RoadConstructionToolComponent(comp.start(), comp.end(), this.roadType, this.roadWidth, this.replaceExistingBlocks));
        DLNetworkManager.sendToServer((BaseNetworkPacket)new RoadBuilderDataPacket(this.replaceExistingBlocks, this.roadWidth, this.roadType));
    }

    protected void onDone() {
        this.updateStackData();
        this.onClose();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)244, (int)179);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.width / 2 - this.font.width((FormattedText)title) / 2), (int)(this.guiTop + 6), (FormattedText)title, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 7), (int)(this.guiTop + 73), (FormattedText)this.roadBlocksText, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 7 + 3), (int)(this.guiTop + 107), (FormattedText)this.requiredResourcesText, (int)-96, (EAlignment)EAlignment.LEFT, (boolean)false);
        String pos1Text = this.pos1 == null ? this.noPositionDefined.getString() : String.format("%s, %s, %s", MathUtils.round((double)this.pos1.x, (int)2), MathUtils.round((double)this.pos1.y, (int)2), MathUtils.round((double)this.pos1.z, (int)2));
        String pos2Text = this.pos2 == null ? this.noPositionDefined.getString() : String.format("%s, %s, %s", MathUtils.round((double)this.pos2.x, (int)2), MathUtils.round((double)this.pos2.y, (int)2), MathUtils.round((double)this.pos2.z, (int)2));
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 7 + 57), (int)(this.guiTop + 22), (String)pos1Text, (int)(this.pos1 == null ? -2285022 : -11184811), (EAlignment)EAlignment.CENTER, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 7 + 116 + 57), (int)(this.guiTop + 22), (String)pos2Text, (int)(this.pos2 == null ? -2285022 : -11184811), (EAlignment)EAlignment.CENTER, (boolean)false);
        if (this.pos1 != null && this.pos2 != null) {
            String blockCountText = String.format("x %s", this.blocksCount);
            String slopeCountText = String.format("x %s", this.slopesCount);
            int blockDisplayWidth = 20 + this.font.width(blockCountText);
            int slopeDisplayWidth = 20 + this.font.width(slopeCountText);
            int guiCenter = this.guiLeft + 7 + 115;
            graphics.graphics().renderItem(new ItemStack((ItemLike)this.roadType.getBlock()), guiCenter - 57 - blockDisplayWidth / 2, this.guiTop + 122);
            graphics.graphics().renderItem(new ItemStack((ItemLike)this.roadType.getSlope()), guiCenter + 57 - slopeDisplayWidth / 2, this.guiTop + 122);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(guiCenter - 57 - blockDisplayWidth / 2 + 20), (int)(this.guiTop + 127), (String)blockCountText, (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(guiCenter + 57 - slopeDisplayWidth / 2 + 20), (int)(this.guiTop + 127), (String)slopeCountText, (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.buildButtonArea.isInBounds((double)mouseX, (double)mouseY)) {
            if (this.pos1 == null || this.pos2 == null) {
                GuiUtils.renderTooltip((Screen)this, (GuiAreaDefinition)this.buildButtonArea, List.of(this.tooltipBuildMissingPos), (int)(this.width / 4), (Graphics)graphics, (int)mouseX, (int)mouseY);
            } else {
                GuiUtils.renderTooltip((Screen)this, (AbstractWidget)this.buildButton, List.of(this.tooltipBuild), (int)(this.width / 4), (Graphics)graphics, (int)mouseX, (int)mouseY);
            }
        }
    }
}

