/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.WritableSignBlockEntity;
import de.mrjulsen.mcdragonlib.client.builtin.WritableSignScreen;
import de.mrjulsen.trafficcraft.block.WritableTrafficSign;
import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;

public class StreetSignBlockEntity
extends WritableSignBlockEntity
implements IColorBlockEntity {
    private PaintColor color = PaintColor.NONE;

    protected StreetSignBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public StreetSignBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STREET_SIGN_BLOCK_ENTITY.get(), pos, state);
    }

    public WritableSignScreen.WritableSignConfig getRenderConfig() {
        float y = 120.0f;
        return new WritableSignScreen.WritableSignConfig(new WritableSignScreen.ConfiguredLineData[]{new WritableSignScreen.ConfiguredLineData(0.0f, -0.265625f, new Vec2(1.0f, 1.5f), new Vec2(1.5f, 1.5f), 0.9375f, 1.0f, 0)}, true, 0.40625f, y, 96.0f, 90.0f, 0.4f, 0.0f, 0.02f, blockState -> Float.valueOf(90.0f + (blockState.getValue((Property)WritableTrafficSign.FACING) == Direction.EAST || blockState.getValue((Property)WritableTrafficSign.FACING) == Direction.WEST ? ((Direction)blockState.getValue((Property)WritableTrafficSign.FACING)).getOpposite().toYRot() : ((Direction)blockState.getValue((Property)WritableTrafficSign.FACING)).toYRot())), PaintColor.useWhiteOrBlackForeColor(this.getColor().getTextureColor()) ? DyeColor.WHITE.getTextColor() : DyeColor.BLACK.getTextColor());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.color = PaintColor.getByIndex(tag.getInt("color"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("color", this.color.getIndex());
    }

    @Override
    public void setColor(PaintColor color) {
        this.color = color;
        this.notifyUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 512);
    }

    public void setText(String text, int line) {
        super.setText(text, line);
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 512);
    }

    public void setTexts(String[] messages) {
        super.setTexts(messages);
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 512);
    }

    @Override
    public PaintColor getColor() {
        return this.color;
    }
}

