/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.data;

import de.mrjulsen.mcdragonlib.core.IIterableEnum;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.trafficcraft.block.data.IItemIcon;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import de.mrjulsen.trafficcraft.registry.ModItems;
import java.util.Arrays;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ItemLike;

public enum TrafficLightControlType implements StringRepresentable,
ITranslatableEnum,
IItemIcon,
IIterableEnum<TrafficLightControlType>
{
    STATIC("static", 0, (ItemLike)ModBlocks.TRAFFIC_LIGHT.get()),
    OWN_SCHEDULE("own_schedule", 1, (ItemLike)ModItems.PATTERN_CATALOGUE.get()),
    REMOTE("remote", 2, (ItemLike)ModBlocks.TRAFFIC_LIGHT_CONTROLLER.get());

    private String controlType;
    private byte index;
    private ItemLike icon;

    private TrafficLightControlType(String controlType, int index, ItemLike icon) {
        this.controlType = controlType;
        this.index = (byte)index;
        this.icon = icon;
    }

    public String getControlType() {
        return this.controlType;
    }

    public byte getIndex() {
        return this.index;
    }

    @Override
    public ItemLike getItemIcon() {
        return this.icon;
    }

    public String getValueShortTranslationKey() {
        return String.format("enum.trafficcraft.trafficlightcontroltype.short.%s", this.controlType);
    }

    public static TrafficLightControlType getControlTypeByIndex(byte index) {
        return Arrays.stream(TrafficLightControlType.values()).filter(x -> x.getIndex() == index).findFirst().orElse(STATIC);
    }

    public String getSerializedName() {
        return this.controlType;
    }

    public String getEnumName() {
        return "trafficlightcontroltype";
    }

    public String getEnumValueName() {
        return this.getControlType();
    }

    public TrafficLightControlType[] getValues() {
        return TrafficLightControlType.values();
    }
}

