/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.data;

import de.mrjulsen.trafficcraft.block.PaintedAsphaltBlock;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.ColorableBlock;
import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class RoadBlock
extends ColorableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private RoadType defaultRoadType;

    public RoadBlock(BlockBehaviour.Properties properties, RoadType type) {
        super(properties);
        this.defaultRoadType = type;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RoadType getDefaultRoadType() {
        return this.defaultRoadType;
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
    }

    @Override
    public InteractionResult onSetColor(UseOnContext pContext) {
        Object id = "";
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = pContext.getItemInHand();
        Player player = pContext.getPlayer();
        Item item = stack.getItem();
        if (!(item instanceof BrushItem)) {
            return InteractionResult.FAIL;
        }
        BrushItem item2 = (BrushItem)item;
        if (level.getBlockEntity(pos) instanceof IColorBlockEntity) {
            if (state.getBlock() instanceof PaintedAsphaltBlock) {
                id = this.getDefaultRoadType().getRoadType() + "_pattern_" + item2.getPatternId(stack);
            } else if (state.getBlock() instanceof PaintedAsphaltSlope) {
                id = this.getDefaultRoadType().getRoadType() + "_slope_pattern_" + item2.getPatternId(stack);
            }
            if (!ModBlocks.ROAD_BLOCKS.containsKey(id)) {
                return InteractionResult.FAIL;
            }
            BlockState newState = (BlockState)((Block)ModBlocks.ROAD_BLOCKS.get(id).get()).defaultBlockState().setValue((Property)FACING, (Comparable)player.getDirection());
            if (state.getBlock() instanceof PaintedAsphaltSlope) {
                newState = (BlockState)newState.setValue((Property)PaintedAsphaltSlope.LAYERS, (Comparable)((Integer)state.getValue((Property)PaintedAsphaltSlope.LAYERS)));
            }
            level.setBlockAndUpdate(pos, newState);
            super.onSetColor(pContext);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public InteractionResult update(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = pContext.getItemInHand();
        Item item = stack.getItem();
        if (!(item instanceof BrushItem)) {
            return InteractionResult.FAIL;
        }
        BrushItem item2 = (BrushItem)item;
        Object id = "";
        if (state.getBlock() instanceof PaintedAsphaltBlock) {
            id = this.getDefaultRoadType().getRoadType() + "_pattern_" + item2.getPatternId(stack);
        } else if (state.getBlock() instanceof PaintedAsphaltSlope) {
            id = this.getDefaultRoadType().getRoadType() + "_slope_pattern_" + item2.getPatternId(stack);
        }
        if (ModBlocks.ROAD_BLOCKS.containsKey(id) && state.getBlock() != ModBlocks.ROAD_BLOCKS.get(id).get()) {
            return this.onSetColor(pContext);
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getClockWise(Direction.Axis.Y)));
        level.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 0.8f, 2.0f);
        return InteractionResult.SUCCESS;
    }
}

