/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrafficSignPostBlock
extends Block
implements SimpleWaterloggedBlock,
ITrafficPostLike {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    public static final BooleanProperty EXTEND_BOTTOM = BooleanProperty.create((String)"bottom_extension");
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().collect(Util.toMap());
    private static final VoxelShape SHAPE_BASE = Block.box((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_UP = Block.box((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_DOWN = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0);
    private static final VoxelShape SHAPE_EXTEND_DOWN = Block.box((double)7.0, (double)-16.0, (double)7.0, (double)9.0, (double)0.0, (double)9.0);

    public TrafficSignPostBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f).requiresCorrectToolForDrops().sound(SoundType.LANTERN));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)EXTEND_BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape = SHAPE_BASE;
        if (!(pState.getValue(AXIS) != Direction.Axis.X || ((Boolean)pState.getValue((Property)NORTH)).booleanValue() || ((Boolean)pState.getValue((Property)SOUTH)).booleanValue() || ((Boolean)pState.getValue((Property)UP)).booleanValue() || ((Boolean)pState.getValue((Property)DOWN)).booleanValue())) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{SHAPE_EAST, SHAPE_WEST});
        } else if (!(pState.getValue(AXIS) != Direction.Axis.Z || ((Boolean)pState.getValue((Property)EAST)).booleanValue() || ((Boolean)pState.getValue((Property)WEST)).booleanValue() || ((Boolean)pState.getValue((Property)UP)).booleanValue() || ((Boolean)pState.getValue((Property)DOWN)).booleanValue())) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{SHAPE_NORTH, SHAPE_SOUTH});
        } else if (!(pState.getValue(AXIS) != Direction.Axis.Y || ((Boolean)pState.getValue((Property)EAST)).booleanValue() || ((Boolean)pState.getValue((Property)WEST)).booleanValue() || ((Boolean)pState.getValue((Property)NORTH)).booleanValue() || ((Boolean)pState.getValue((Property)SOUTH)).booleanValue())) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{SHAPE_UP, SHAPE_DOWN});
        } else {
            if (((Boolean)pState.getValue((Property)NORTH)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
            }
            if (((Boolean)pState.getValue((Property)EAST)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
            }
            if (((Boolean)pState.getValue((Property)SOUTH)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
            }
            if (((Boolean)pState.getValue((Property)WEST)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
            }
            if (((Boolean)pState.getValue((Property)UP)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_UP);
            }
            if (((Boolean)pState.getValue((Property)DOWN)).booleanValue()) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_DOWN);
            }
        }
        if (((Boolean)pState.getValue((Property)EXTEND_BOTTOM)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_EXTEND_DOWN);
        }
        return shape;
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return TrafficSignPostBlock.rotatePillar(pState, pRot);
    }

    public static BlockState rotatePillar(BlockState pState, Rotation pRotation) {
        switch (pRotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)pState.getValue(AXIS)) {
                    case X: {
                        return (BlockState)pState.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)pState.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return pState;
            }
        }
        return pState;
    }

    private static boolean needsBottomExtension(BlockState pState, BlockState belowBlock) {
        return ((Direction.Axis)pState.getValue(AXIS)).test(Direction.UP) && (belowBlock.hasProperty((Property)BlockStateProperties.LAYERS) || belowBlock.getBlock() instanceof SlabBlock && belowBlock.getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.BOTTOM);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        BlockState belowBlock = pLevel.getBlockState(pCurrentPos.below());
        return (BlockState)((BlockState)pState.setValue((Property)PROPERTY_BY_DIRECTION.get(pFacing), (Comparable)Boolean.valueOf(this.connectsTo(pLevel, pCurrentPos, pState, pFacingState, pFacingState.isFaceSturdy((BlockGetter)pLevel, pFacingPos, pFacing.getOpposite()), pFacing.getOpposite())))).setValue((Property)EXTEND_BOTTOM, (Comparable)Boolean.valueOf(TrafficSignPostBlock.needsBottomExtension(pState, belowBlock)));
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        Level blockgetter = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.east();
        BlockPos blockpos3 = blockpos.south();
        BlockPos blockpos4 = blockpos.west();
        BlockPos blockpos5 = blockpos.above();
        BlockPos blockpos6 = blockpos.below();
        BlockState blockstate1 = blockgetter.getBlockState(blockpos1);
        BlockState blockstate2 = blockgetter.getBlockState(blockpos2);
        BlockState blockstate3 = blockgetter.getBlockState(blockpos3);
        BlockState blockstate4 = blockgetter.getBlockState(blockpos4);
        BlockState blockstate5 = blockgetter.getBlockState(blockpos5);
        BlockState blockstate6 = blockgetter.getBlockState(blockpos6);
        BlockState newState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue(AXIS, (Comparable)pContext.getClickedFace().getAxis());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.getLevel(), pContext.getClickedPos(), newState, blockstate1, blockstate1.isFaceSturdy((BlockGetter)blockgetter, blockpos1, Direction.SOUTH), Direction.SOUTH.getOpposite())))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.getLevel(), pContext.getClickedPos(), newState, blockstate2, blockstate2.isFaceSturdy((BlockGetter)blockgetter, blockpos2, Direction.WEST), Direction.WEST.getOpposite())))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.getLevel(), pContext.getClickedPos(), newState, blockstate3, blockstate3.isFaceSturdy((BlockGetter)blockgetter, blockpos3, Direction.NORTH), Direction.NORTH.getOpposite())))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.getLevel(), pContext.getClickedPos(), newState, blockstate4, blockstate4.isFaceSturdy((BlockGetter)blockgetter, blockpos4, Direction.EAST), Direction.EAST.getOpposite())))).setValue((Property)UP, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.getLevel(), pContext.getClickedPos(), newState, blockstate5, blockstate5.isFaceSturdy((BlockGetter)blockgetter, blockpos3, Direction.DOWN), Direction.DOWN)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.getLevel(), pContext.getClickedPos(), newState, blockstate6, blockstate6.isFaceSturdy((BlockGetter)blockgetter, blockpos4, Direction.UP), Direction.UP)))).setValue((Property)EXTEND_BOTTOM, (Comparable)Boolean.valueOf(TrafficSignPostBlock.needsBottomExtension(newState, blockstate6)));
    }

    private boolean isSameBlock(BlockState pState) {
        return pState.is((Block)this);
    }

    public boolean connectsTo(LevelAccessor level, BlockPos pos, BlockState pState, BlockState pTargetState, boolean pIsSideSolid, Direction pDirection) {
        boolean flag = this.isSameBlock(pTargetState);
        boolean canConnect = false;
        Block block = pTargetState.getBlock();
        if (block instanceof ITrafficPostLike) {
            ITrafficPostLike postLike = (ITrafficPostLike)block;
            canConnect = postLike.canConnect(pTargetState, pDirection);
        }
        return !TrafficSignPostBlock.isExceptionForConnection((BlockState)pTargetState) && (canConnect || ((Direction.Axis)pState.getValue(AXIS)).test(pDirection) && pIsSideSolid) || flag || pDirection == Direction.UP && TrafficSignPostBlock.needsBottomExtension(pState, pTargetState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{WATERLOGGED, AXIS, NORTH, SOUTH, WEST, EAST, UP, DOWN, EXTEND_BOTTOM});
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return pState.getValue(AXIS) == Direction.Axis.Y && (Boolean)pState.getValue((Property)EAST) == false && (Boolean)pState.getValue((Property)WEST) == false && (Boolean)pState.getValue((Property)NORTH) == false && (Boolean)pState.getValue((Property)SOUTH) == false || (Boolean)pState.getValue((Property)UP) != false;
    }

    @Override
    public boolean canConnect(BlockState pState, Direction pDirection) {
        return true;
    }
}

