/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.StreetLampBaseBlock;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StreetLightBlock
extends StreetLampBaseBlock {
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().collect(Util.toMap());
    protected static final VoxelShape SHAPE_BASE_SN = Block.box((double)5.0, (double)5.75, (double)3.0, (double)11.0, (double)9.3, (double)13.0);
    protected static final VoxelShape SHAPE_BASE_EW = Block.box((double)3.0, (double)5.75, (double)5.0, (double)13.0, (double)9.3, (double)11.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);

    public StreetLightBlock(BlockBehaviour.Properties properties) {
        super(properties, StreetLampBaseBlock.LampType.SINGLE_LIGHT);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE_COMMON;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape;
        VoxelShape voxelShape = shape = pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE_BASE_SN : SHAPE_BASE_EW;
        if (Boolean.TRUE.equals(pState.getValue((Property)NORTH))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (Boolean.TRUE.equals(pState.getValue((Property)EAST))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        if (Boolean.TRUE.equals(pState.getValue((Property)SOUTH))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (Boolean.TRUE.equals(pState.getValue((Property)WEST))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        if (Boolean.TRUE.equals(pState.getValue((Property)UP))) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_UP);
        }
        return shape;
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState state = super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        return this.canConnect(pState, pFacing) ? (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(pFacing), (Comparable)Boolean.valueOf(this.connectsTo(pState, pFacingState, pFacingState.isFaceSturdy((BlockGetter)pLevel, pFacingPos, pFacing.getOpposite()), pFacing.getOpposite()))) : state;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level blockgetter = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.east();
        BlockPos blockpos3 = blockpos.south();
        BlockPos blockpos4 = blockpos.west();
        BlockPos blockpos5 = blockpos.above();
        BlockState blockstate1 = blockgetter.getBlockState(blockpos1);
        BlockState blockstate2 = blockgetter.getBlockState(blockpos2);
        BlockState blockstate3 = blockgetter.getBlockState(blockpos3);
        BlockState blockstate4 = blockgetter.getBlockState(blockpos4);
        BlockState blockstate5 = blockgetter.getBlockState(blockpos5);
        BlockState newState = super.getStateForPlacement(pContext);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate1, blockstate1.isFaceSturdy((BlockGetter)blockgetter, blockpos1, Direction.SOUTH), Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate2, blockstate2.isFaceSturdy((BlockGetter)blockgetter, blockpos2, Direction.WEST), Direction.WEST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate3, blockstate3.isFaceSturdy((BlockGetter)blockgetter, blockpos3, Direction.NORTH), Direction.NORTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate4, blockstate4.isFaceSturdy((BlockGetter)blockgetter, blockpos4, Direction.EAST), Direction.EAST)))).setValue((Property)UP, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate5, blockstate5.isFaceSturdy((BlockGetter)blockgetter, blockpos3, Direction.UP), Direction.UP)));
    }

    private boolean isSameBlock(BlockState pState) {
        return pState.is((Block)this);
    }

    public boolean connectsTo(BlockState pState, BlockState pTargetState, boolean pIsSideSolid, Direction pDirection) {
        boolean flag = this.isSameBlock(pTargetState);
        boolean canConnect = false;
        Block block = pTargetState.getBlock();
        if (block instanceof ITrafficPostLike) {
            ITrafficPostLike postLike = (ITrafficPostLike)block;
            canConnect = postLike.canConnect(pTargetState, pDirection);
        }
        return !StreetLightBlock.isExceptionForConnection((BlockState)pTargetState) && (canConnect || pState.getValue((Property)FACING) == pDirection && pIsSideSolid) || flag;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{NORTH, SOUTH, WEST, EAST, UP});
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return false;
    }

    @Override
    public boolean canConnect(BlockState pState, Direction pDirection) {
        return pDirection != Direction.DOWN;
    }
}

