/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.mcdragonlib.core.IIterableEnum;
import de.mrjulsen.trafficcraft.block.entity.EmptyBlockEntity;
import de.mrjulsen.trafficcraft.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoadSaltBlock
extends BaseEntityBlock {
    public static final MapCodec<RoadSaltBlock> CODEC = RoadSaltBlock.simpleCodec(RoadSaltBlock::new);
    public static final EnumProperty<RoadSaltQuality> QUALITY = EnumProperty.create((String)"quality", RoadSaltQuality.class);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RoadSaltBlock(BlockBehaviour.Properties properties) {
        super(properties.instabreak().noOcclusion().noCollission().instabreak().pushReaction(PushReaction.DESTROY).noLootTable().sound(SoundType.GRAVEL));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(QUALITY, (Comparable)((Object)RoadSaltQuality.FRESH)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{QUALITY});
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == Direction.DOWN && !this.canSurvive(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : pState;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        return this.canSurviveOn((BlockGetter)level, blockpos, blockstate);
    }

    private boolean canSurviveOn(BlockGetter reader, BlockPos pos, BlockState state) {
        return state.isFaceSturdy(reader, pos, Direction.UP);
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return true;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return true;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new EmptyBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.isClientSide) {
            return (level, pos, state, blockEntity) -> {
                int randTicks = ((GameRules.IntegerValue)level.getGameRules().getRule(GameRules.RULE_RANDOMTICKING)).get();
                if (randTicks <= 0 || level.getRandom().nextInt((Integer)ModCommonConfig.ROAD_SALT_SPEED.get() * 3 * (((RoadSaltQuality)((Object)((Object)pState.getValue(QUALITY)))).getIndex() + 1) / randTicks) != 0) {
                    return;
                }
                ArrayList blocks = new ArrayList();
                BlockPos.betweenClosed((BlockPos)pos.offset(-((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue(), -((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue(), -((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue()), (BlockPos)pos.offset(((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue(), 1, ((Integer)ModCommonConfig.ROAD_SALT_RANGE.get()).intValue())).iterator().forEachRemaining(a -> blocks.add(new BlockPos((Vec3i)a)));
                Collections.shuffle(blocks);
                Iterator iterator = blocks.iterator();
                do {
                    BlockPos blockpos;
                    if ((blockpos = (BlockPos)iterator.next()).distManhattan((Vec3i)pos) > (Integer)ModCommonConfig.ROAD_SALT_RANGE.get()) continue;
                    if (level.getBlockState(blockpos).is(Blocks.SNOW) || level.getBlockState(blockpos).is(Blocks.ICE)) {
                        Block.dropResources((BlockState)state, (Level)level, (BlockPos)blockpos);
                        level.removeBlock(blockpos, false);
                        if ((Integer)ModCommonConfig.ROAD_SALT_PRESERVATION.get() >= 0 && level.getRandom().nextInt((Integer)ModCommonConfig.ROAD_SALT_PRESERVATION.get() * (((RoadSaltQuality)((Object)((Object)pState.getValue(QUALITY)))).getIndex() + 1)) == 0) {
                            RoadSaltQuality quality = (RoadSaltQuality)((RoadSaltQuality)((Object)((Object)level.getBlockState(pos).getValue(QUALITY)))).next();
                            if (quality.getIndex() == 0) {
                                level.removeBlock(pos, false);
                            } else {
                                level.setBlockAndUpdate(pos, (BlockState)pState.setValue(QUALITY, (Comparable)((Object)quality)));
                            }
                        }
                        return;
                    }
                    if (!((Boolean)ModCommonConfig.ROAD_SALT_DAMAGE.get()).booleanValue()) continue;
                    if (level.getBlockState(blockpos).is(BlockTags.DIRT) && !level.getBlockState(blockpos).is(Blocks.COARSE_DIRT)) {
                        level.setBlockAndUpdate(blockpos, Blocks.COARSE_DIRT.defaultBlockState());
                        return;
                    }
                    if (level.getBlockState(blockpos).is(BlockTags.SMALL_FLOWERS) || level.getBlockState(blockpos).is(BlockTags.CROPS)) {
                        level.removeBlock(blockpos, false);
                        return;
                    }
                    if (level.getBlockState(blockpos).is(Blocks.DEAD_BUSH) || !level.getBlockState(blockpos).is(BlockTags.SAPLINGS)) continue;
                    level.setBlockAndUpdate(blockpos, Blocks.DEAD_BUSH.defaultBlockState());
                    return;
                } while (iterator.hasNext());
            };
        }
        return null;
    }

    public static enum RoadSaltQuality implements StringRepresentable,
    IIterableEnum<RoadSaltQuality>
    {
        FRESH(0, "fresh"),
        MUDDY(1, "muddy"),
        DILUTED(2, "diluted");

        private final int index;
        private final String name;

        private RoadSaltQuality(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public RoadSaltQuality[] getValues() {
            return RoadSaltQuality.values();
        }
    }
}

