/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.mrjulsen.trafficcraft.block.AsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.RoadBlock;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PaintedAsphaltSlope
extends RoadBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<PaintedAsphaltSlope> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PaintedAsphaltSlope.propertiesCodec(), (App)RoadType.CODEC.fieldOf("road_type").forGetter(RoadBlock::getDefaultRoadType)).apply((Applicative)instance, PaintedAsphaltSlope::new));
    private RegistrySupplier<Block> pickupBlock;
    public static final int MAX_HEIGHT = 8;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.empty(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public static final int HEIGHT_IMPASSABLE = 5;

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public PaintedAsphaltSlope(BlockBehaviour.Properties properties, RoadType type) {
        super(properties.mapColor(MapColor.STONE).strength(1.5f).requiresCorrectToolForDrops(), type);
        this.pickupBlock = type.getPickupBlock();
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.pickupBlock == null || this.pickupBlock == this ? super.getCloneItemStack(level, pos, state) : ((Block)this.pickupBlock.get()).getCloneItemStack(level, pos, state);
    }

    @Override
    public void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        this.onRemoveColor(pState, pLevel, pPos, pPlayer);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        switch (pathComputationType) {
            case LAND: {
                return (Integer)state.getValue((Property)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public VoxelShape getVisualShape(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        int i = (Integer)pState.getValue((Property)LAYERS);
        Item item = pUseContext.getItemInHand().getItem();
        if (item instanceof BlockItem) {
            Block block;
            BlockItem blockitem = (BlockItem)item;
            if (i < 8 && (block = blockitem.getBlock()) instanceof AsphaltSlope) {
                AsphaltSlope selectedSlope = (AsphaltSlope)block;
                block = pState.getBlock();
                if (block instanceof PaintedAsphaltSlope) {
                    PaintedAsphaltSlope targetSlope = (PaintedAsphaltSlope)block;
                    if (selectedSlope.getDefaultRoadType() == targetSlope.getDefaultRoadType()) {
                        if (pUseContext.replacingClickedOnBlock()) {
                            return pUseContext.getClickedFace() == Direction.UP;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        boolean flag;
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos());
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean bl = flag = fluidstate.getType() == Fluids.WATER;
        if (blockstate.getBlock() instanceof AsphaltSlope) {
            int i = (Integer)blockstate.getValue((Property)LAYERS);
            return (BlockState)((BlockState)blockstate.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)super.getStateForPlacement(pContext).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LAYERS, WATERLOGGED});
        super.createBlockStateDefinition(pBuilder);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @Override
    public void onRemoveColor(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        ItemStack stack = pPlayer.getInventory().getSelected();
        Item item = stack.getItem();
        if (!(item instanceof BrushItem)) {
            return;
        }
        if (this == ModBlocks.ASPHALT_SLOPE.get() || this == ModBlocks.CONCRETE_SLOPE.get()) {
            return;
        }
        switch (this.getDefaultRoadType()) {
            case ASPHALT: {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)ModBlocks.ASPHALT_SLOPE.get()).defaultBlockState().setValue((Property)LAYERS, (Comparable)((Integer)pState.getValue((Property)LAYERS))));
                pLevel.playSound(null, pPos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 0.8f, 2.0f);
                break;
            }
            case CONCRETE: {
                pLevel.setBlockAndUpdate(pPos, (BlockState)((Block)ModBlocks.CONCRETE_SLOPE.get()).defaultBlockState().setValue((Property)LAYERS, (Comparable)((Integer)pState.getValue((Property)LAYERS))));
                pLevel.playSound(null, pPos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 0.8f, 2.0f);
                break;
            }
        }
    }
}

