/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.trafficcraft.block.data.ColorableBlock;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GuardrailBlock
extends ColorableBlock
implements SimpleWaterloggedBlock,
ITrafficPostLike {
    public static final MapCodec<GuardrailBlock> CODEC = GuardrailBlock.simpleCodec(GuardrailBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_POST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_XP_SOUTH = Block.box((double)9.0, (double)8.5, (double)5.5, (double)16.0, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_XN_SOUTH = Block.box((double)0.0, (double)8.5, (double)5.5, (double)7.0, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_XP_NORTH = Block.box((double)9.0, (double)8.5, (double)9.0, (double)16.0, (double)15.5, (double)10.5);
    private static final VoxelShape SHAPE_XN_NORTH = Block.box((double)0.0, (double)8.5, (double)9.0, (double)7.0, (double)15.5, (double)10.5);
    private static final VoxelShape SHAPE_ZP_EAST = Block.box((double)5.5, (double)8.5, (double)9.0, (double)7.0, (double)15.5, (double)16.0);
    private static final VoxelShape SHAPE_ZN_EAST = Block.box((double)5.5, (double)8.5, (double)0.0, (double)7.0, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_ZP_WEST = Block.box((double)9.0, (double)8.5, (double)9.0, (double)10.5, (double)15.5, (double)16.0);
    private static final VoxelShape SHAPE_ZN_WEST = Block.box((double)9.0, (double)8.5, (double)0.0, (double)10.5, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)5.5, (double)8.5, (double)5.5, (double)10.5, (double)15.5, (double)7.0);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)5.5, (double)8.5, (double)9.0, (double)10.5, (double)15.5, (double)10.5);
    private static final VoxelShape SHAPE_EAST = Block.box((double)5.5, (double)8.5, (double)5.5, (double)7.0, (double)15.5, (double)10.5);
    private static final VoxelShape SHAPE_WEST = Block.box((double)9.0, (double)8.5, (double)5.5, (double)10.5, (double)15.5, (double)10.5);
    private static final VoxelShape COLLISION_POST = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)24.0, (double)9.0);
    private static final VoxelShape COLLISION_XP_SOUTH = Block.box((double)9.0, (double)8.5, (double)5.5, (double)16.0, (double)24.0, (double)7.0);
    private static final VoxelShape COLLISION_XN_SOUTH = Block.box((double)0.0, (double)8.5, (double)5.5, (double)7.0, (double)24.0, (double)7.0);
    private static final VoxelShape COLLISION_XP_NORTH = Block.box((double)9.0, (double)8.5, (double)9.0, (double)16.0, (double)24.0, (double)10.5);
    private static final VoxelShape COLLISION_XN_NORTH = Block.box((double)0.0, (double)8.5, (double)9.0, (double)7.0, (double)24.0, (double)10.5);
    private static final VoxelShape COLLISION_ZP_EAST = Block.box((double)5.5, (double)8.5, (double)9.0, (double)7.0, (double)24.0, (double)16.0);
    private static final VoxelShape COLLISION_ZN_EAST = Block.box((double)5.5, (double)8.5, (double)0.0, (double)7.0, (double)24.0, (double)7.0);
    private static final VoxelShape COLLISION_ZP_WEST = Block.box((double)9.0, (double)8.5, (double)9.0, (double)10.5, (double)24.0, (double)16.0);
    private static final VoxelShape COLLISION_ZN_WEST = Block.box((double)9.0, (double)8.5, (double)0.0, (double)10.5, (double)15.5, (double)7.0);
    private static final VoxelShape COLLISION_SOUTH = Block.box((double)5.5, (double)8.5, (double)5.5, (double)10.5, (double)24.0, (double)7.0);
    private static final VoxelShape COLLISION_NORTH = Block.box((double)5.5, (double)8.5, (double)9.0, (double)10.5, (double)24.0, (double)10.5);
    private static final VoxelShape COLLISION_EAST = Block.box((double)5.5, (double)8.5, (double)5.5, (double)7.0, (double)24.0, (double)10.5);
    private static final VoxelShape COLLISION_WEST = Block.box((double)9.0, (double)8.5, (double)5.5, (double)10.5, (double)24.0, (double)10.5);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public GuardrailBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(2.0f).sound(SoundType.LANTERN));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        StairsShape shape = (StairsShape)pState.getValue(SHAPE);
        if (direction == Direction.NORTH && shape == StairsShape.STRAIGHT) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_NORTH, SHAPE_XN_NORTH, SHAPE_NORTH});
        }
        if (direction == Direction.SOUTH && shape == StairsShape.STRAIGHT) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_SOUTH, SHAPE_XN_SOUTH, SHAPE_SOUTH});
        }
        if (direction == Direction.EAST && shape == StairsShape.STRAIGHT) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_EAST, SHAPE_ZN_EAST, SHAPE_EAST});
        }
        if (direction == Direction.WEST && shape == StairsShape.STRAIGHT) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_WEST, SHAPE_ZN_WEST, SHAPE_WEST});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.NORTH) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_EAST, SHAPE_XN_NORTH});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.NORTH) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_WEST, SHAPE_XP_NORTH});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.EAST) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XN_SOUTH, SHAPE_ZN_EAST});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.EAST) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XN_NORTH, SHAPE_ZP_EAST});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.SOUTH) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZN_WEST, SHAPE_XP_SOUTH});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.SOUTH) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZN_EAST, SHAPE_XN_SOUTH});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.WEST) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_NORTH, SHAPE_ZP_WEST});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.WEST) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_SOUTH, SHAPE_ZN_WEST});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.NORTH) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZN_EAST, SHAPE_XP_NORTH, SHAPE_EAST, SHAPE_NORTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.NORTH) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZN_WEST, SHAPE_XN_NORTH, SHAPE_WEST, SHAPE_NORTH});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.EAST) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_SOUTH, SHAPE_ZP_EAST, SHAPE_SOUTH, SHAPE_EAST});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.EAST) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XP_NORTH, SHAPE_ZN_EAST, SHAPE_NORTH, SHAPE_EAST});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.SOUTH) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_WEST, SHAPE_XN_SOUTH, SHAPE_WEST, SHAPE_SOUTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.SOUTH) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_ZP_EAST, SHAPE_XP_SOUTH, SHAPE_EAST, SHAPE_SOUTH});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.WEST) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XN_NORTH, SHAPE_ZN_WEST, SHAPE_WEST, SHAPE_NORTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.WEST) {
            return Shapes.or((VoxelShape)SHAPE_POST, (VoxelShape[])new VoxelShape[]{SHAPE_XN_SOUTH, SHAPE_ZP_WEST, SHAPE_WEST, SHAPE_SOUTH});
        }
        return SHAPE_POST;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        StairsShape shape = (StairsShape)pState.getValue(SHAPE);
        if (direction == Direction.NORTH && shape == StairsShape.STRAIGHT) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_NORTH, COLLISION_XN_NORTH, COLLISION_NORTH});
        }
        if (direction == Direction.SOUTH && shape == StairsShape.STRAIGHT) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_SOUTH, COLLISION_XN_SOUTH, COLLISION_SOUTH});
        }
        if (direction == Direction.EAST && shape == StairsShape.STRAIGHT) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_EAST, COLLISION_ZN_EAST, COLLISION_EAST});
        }
        if (direction == Direction.WEST && shape == StairsShape.STRAIGHT) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_WEST, COLLISION_ZN_WEST, COLLISION_WEST});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.NORTH) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_EAST, COLLISION_XN_NORTH});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.NORTH) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_WEST, COLLISION_XP_NORTH});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.EAST) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XN_SOUTH, COLLISION_ZN_EAST});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.EAST) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XN_NORTH, COLLISION_ZP_EAST});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.SOUTH) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZN_WEST, COLLISION_XP_SOUTH});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.SOUTH) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZN_EAST, COLLISION_XN_SOUTH});
        }
        if (shape == StairsShape.INNER_RIGHT && direction == Direction.WEST) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_NORTH, COLLISION_ZP_WEST});
        }
        if (shape == StairsShape.INNER_LEFT && direction == Direction.WEST) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_SOUTH, COLLISION_ZN_WEST});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.NORTH) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZN_EAST, COLLISION_XP_NORTH, COLLISION_EAST, COLLISION_NORTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.NORTH) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZN_WEST, COLLISION_XN_NORTH, COLLISION_WEST, COLLISION_NORTH});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.EAST) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_SOUTH, COLLISION_ZP_EAST, COLLISION_SOUTH, COLLISION_EAST});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.EAST) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XP_NORTH, COLLISION_ZN_EAST, COLLISION_NORTH, COLLISION_EAST});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.SOUTH) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_WEST, COLLISION_XN_SOUTH, COLLISION_WEST, COLLISION_SOUTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.SOUTH) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_ZP_EAST, COLLISION_XP_SOUTH, COLLISION_EAST, COLLISION_SOUTH});
        }
        if (shape == StairsShape.OUTER_RIGHT && direction == Direction.WEST) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XN_NORTH, COLLISION_ZN_WEST, COLLISION_WEST, COLLISION_NORTH});
        }
        if (shape == StairsShape.OUTER_LEFT && direction == Direction.WEST) {
            return Shapes.or((VoxelShape)COLLISION_POST, (VoxelShape[])new VoxelShape[]{COLLISION_XN_SOUTH, COLLISION_ZP_WEST, COLLISION_WEST, COLLISION_SOUTH});
        }
        return COLLISION_POST;
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        StairsShape stairsshape = (StairsShape)pState.getValue(SHAPE);
        switch (pMirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return pState.rotate(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return pState.rotate(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.mirror(pState, pMirror);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return pFacing.getAxis().isHorizontal() ? (BlockState)pState.setValue(SHAPE, (Comparable)GuardrailBlock.getGuardrailShape(pState, (BlockGetter)pLevel, pCurrentPos)) : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private static StairsShape getGuardrailShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)pState.getValue((Property)FACING);
        BlockState blockstate = pLevel.getBlockState(pPos.relative(direction));
        if (GuardrailBlock.isGuardrail(blockstate) && (direction1 = (Direction)blockstate.getValue((Property)FACING)).getAxis() != ((Direction)pState.getValue((Property)FACING)).getAxis() && GuardrailBlock.canTakeShape(pState, pLevel, pPos, direction1.getOpposite())) {
            if (direction1 == direction.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = pLevel.getBlockState(pPos.relative(direction.getOpposite()));
        if (GuardrailBlock.isGuardrail(blockstate1) && (direction2 = (Direction)blockstate1.getValue((Property)FACING)).getAxis() != ((Direction)pState.getValue((Property)FACING)).getAxis() && GuardrailBlock.canTakeShape(pState, pLevel, pPos, direction2)) {
            if (direction2 == direction.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pFace) {
        BlockState blockstate = pLevel.getBlockState(pPos.relative(pFace));
        return !GuardrailBlock.isGuardrail(blockstate) || blockstate.getValue((Property)FACING) != pState.getValue((Property)FACING);
    }

    public static boolean isGuardrail(BlockState pState) {
        return pState.getBlock() instanceof GuardrailBlock;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(blockpos);
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return (BlockState)blockstate.setValue(SHAPE, (Comparable)GuardrailBlock.getGuardrailShape(blockstate, (BlockGetter)pContext.getLevel(), blockpos));
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    public int getDefaultColor() {
        return -8224126;
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return pDirection == ((Direction)pState.getValue((Property)FACING)).getOpposite();
    }
}

