/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.AsphaltSlope;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.IPaintableBlock;
import de.mrjulsen.trafficcraft.block.data.RoadBlock;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.components.BrushComponent;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class AsphaltBlock
extends Block
implements IPaintableBlock {
    private RoadType defaultRoadType;

    public AsphaltBlock(RoadType type) {
        super(AsphaltBlock.properties(type));
        this.defaultRoadType = type;
    }

    public static BlockBehaviour.Properties properties(RoadType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f).requiresCorrectToolForDrops();
        switch (type) {
            case ASPHALT: {
                props.mapColor(MapColor.COLOR_GRAY);
                break;
            }
            case CONCRETE: {
                props.mapColor(MapColor.CLAY);
                break;
            }
        }
        return props;
    }

    public RoadType getDefaultRoadType() {
        return this.defaultRoadType;
    }

    @Override
    public InteractionResult onSetColor(UseOnContext pContext) {
        Object id = "";
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        BlockState state = pContext.getLevel().getBlockState(pos);
        ItemStack stack = pContext.getItemInHand();
        Player player = pContext.getPlayer();
        Item item = stack.getItem();
        if (!(item instanceof BrushItem)) {
            return InteractionResult.FAIL;
        }
        BrushItem item2 = (BrushItem)item;
        if (state.getBlock() instanceof AsphaltSlope) {
            id = this.getDefaultRoadType().getRoadType() + "_slope_pattern_" + ((BrushComponent)item2.getComponent(stack)).patternId();
        } else if (state.getBlock() instanceof AsphaltBlock) {
            id = this.getDefaultRoadType().getRoadType() + "_pattern_" + ((BrushComponent)item2.getComponent(stack)).patternId();
        }
        if (!ModBlocks.ROAD_BLOCKS.containsKey(id) || !(ModBlocks.ROAD_BLOCKS.get(id).get() instanceof RoadBlock)) {
            return InteractionResult.FAIL;
        }
        RoadBlock road = (RoadBlock)ModBlocks.ROAD_BLOCKS.get(id).get();
        BlockState newState = (BlockState)road.defaultBlockState().setValue((Property)RoadBlock.FACING, (Comparable)player.getDirection());
        if (state.getBlock() instanceof AsphaltSlope) {
            newState = (BlockState)newState.setValue((Property)PaintedAsphaltSlope.LAYERS, (Comparable)((Integer)state.getValue((Property)AsphaltSlope.LAYERS)));
        }
        level.setBlockAndUpdate(pos, newState);
        road.onSetColor(pContext);
        return InteractionResult.CONSUME;
    }
}

