/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import java.util.List;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.math.MathUtils;
import mekanism.api.radiation.IRadiationManager;

public interface ITileRadioactive {
    public static float calculateRadiationScale(List<IChemicalTank> tanks) {
        if (IRadiationManager.INSTANCE.isRadiationEnabled() && !tanks.isEmpty()) {
            if (tanks.size() == 1) {
                IChemicalTank tank = tanks.getFirst();
                if (!tank.isEmpty() && tank.getStack().isRadioactive()) {
                    return (float)tank.getStored() / (float)tank.getCapacity();
                }
                return 0.0f;
            }
            float summedScale = 0.0f;
            for (IChemicalTank tank : tanks) {
                if (tank.isEmpty() || !tank.getStack().isRadioactive()) continue;
                summedScale += (float)tank.getStored() / (float)tank.getCapacity();
            }
            return summedScale / (float)tanks.size();
        }
        return 0.0f;
    }

    public float getRadiationScale();

    default public int getRadiationParticleCount() {
        return MathUtils.clampToInt(10.0f * this.getRadiationScale());
    }
}

