/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IHashedItem;
import mekanism.common.util.StackUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class HashedItem
implements IHashedItem {
    public static final Codec<HashedItem> CODEC = ItemStack.SINGLE_ITEM_CODEC.xmap(HashedItem::raw, HashedItem::getInternalStack);
    public static final StreamCodec<RegistryFriendlyByteBuf, HashedItem> STREAM_CODEC = ItemStack.STREAM_CODEC.map(HashedItem::raw, HashedItem::getInternalStack);
    private final ItemStack itemStack;
    private final int hashCode;

    public static HashedItem create(ItemStack stack) {
        return new HashedItem(stack.copyWithCount(1));
    }

    public static HashedItem raw(ItemStack stack) {
        return new HashedItem(stack);
    }

    protected HashedItem(ItemStack stack) {
        this.itemStack = stack;
        this.hashCode = ItemStack.hashItemAndComponents((ItemStack)this.itemStack);
    }

    protected HashedItem(HashedItem other) {
        this(other.itemStack, other.hashCode);
    }

    protected HashedItem(ItemStack stack, int hashCode) {
        this.itemStack = stack;
        this.hashCode = hashCode;
    }

    @Override
    public ItemStack getInternalStack() {
        return this.itemStack;
    }

    @Override
    public ItemStack createStack(int size) {
        return StackUtils.size(this.itemStack, size);
    }

    public HashedItem recreate() {
        return new HashedItem(this.createStack(1), this.hashCode);
    }

    @NotNull
    public Tag internalToNBT(HolderLookup.Provider provider) {
        return this.itemStack.save(provider);
    }

    public boolean isSameItemSameComponents(ItemStack other) {
        return ItemStack.isSameItemSameComponents((ItemStack)this.itemStack, (ItemStack)other);
    }

    public boolean equals(Object obj) {
        IHashedItem other;
        if (obj == this) {
            return true;
        }
        return obj instanceof IHashedItem && this.isSameItemSameComponents((other = (IHashedItem)obj).getInternalStack());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.valueOf(this.itemStack.getItem()) + " with components: " + String.valueOf(this.itemStack.getComponentsPatch());
    }

    public static class UUIDAwareHashedItem
    extends HashedItem {
        public static final StreamCodec<RegistryFriendlyByteBuf, UUIDAwareHashedItem> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, HashedItem::getInternalStack, (StreamCodec)UUIDUtil.STREAM_CODEC, UUIDAwareHashedItem::getUUID, UUIDAwareHashedItem::new);
        @NotNull
        private final UUID uuid;
        private final int uuidBasedHash;

        public UUIDAwareHashedItem(ItemStack stack, @NotNull UUID uuid) {
            super(stack.copyWithCount(1));
            this.uuid = uuid;
            this.uuidBasedHash = Objects.hash(super.hashCode(), this.uuid);
        }

        public UUIDAwareHashedItem(HashedItem other, @NotNull UUID uuid) {
            super(other);
            this.uuid = uuid;
            this.uuidBasedHash = Objects.hash(super.hashCode(), this.uuid);
        }

        @NotNull
        public UUID getUUID() {
            return this.uuid;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof UUIDAwareHashedItem)) return false;
            UUIDAwareHashedItem uuidAware = (UUIDAwareHashedItem)obj;
            if (!this.uuid.equals(uuidAware.uuid)) return false;
            if (!super.equals(obj)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.uuidBasedHash;
        }

        public HashedItem asRawHashedItem() {
            return new HashedItem(this);
        }
    }
}

