/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.item;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.item.FrequencyItemContainer;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PortableTeleporterContainer
extends FrequencyItemContainer<TeleporterFrequency>
implements IEmptyContainer {
    private byte status;

    public PortableTeleporterContainer(int id, Inventory inv, InteractionHand hand, ItemStack stack) {
        super(MekanismContainerTypes.PORTABLE_TELEPORTER, id, inv, hand, stack);
    }

    @Nullable
    public IEnergyContainer getEnergyContainer() {
        return StorageUtils.getEnergyContainer(this.stack, 0);
    }

    public byte getStatus() {
        return this.status;
    }

    @Override
    protected FrequencyType<TeleporterFrequency> getFrequencyType() {
        return FrequencyType.TELEPORTER;
    }

    @Override
    protected void addContainerTrackers() {
        super.addContainerTrackers();
        if (this.getLevel().isClientSide()) {
            this.track(SyncableByte.create(() -> this.status, value -> {
                this.status = value;
            }));
        } else {
            this.track(SyncableByte.create(() -> {
                int status = 3;
                TeleporterFrequency freq = (TeleporterFrequency)this.getFrequencyFromStack();
                if (freq != null && !freq.getActiveCoords().isEmpty()) {
                    status = 1;
                    if (!this.inv.player.isCreative()) {
                        IEnergyContainer energyContainer = this.getEnergyContainer();
                        if (energyContainer == null) {
                            status = 4;
                        } else {
                            long energyNeeded;
                            GlobalPos coords = freq.getClosestCoords(GlobalPos.of((ResourceKey)this.getLevel().dimension(), (BlockPos)this.inv.player.blockPosition()));
                            if (coords != null && (energyNeeded = TileEntityTeleporter.calculateEnergyCost((Entity)this.inv.player, coords)) != -1L && energyContainer.extract(energyNeeded, Action.SIMULATE, AutomationType.MANUAL) < energyNeeded) {
                                status = 4;
                            }
                        }
                    }
                }
                return (byte)status;
            }, value -> {
                this.status = value;
            }));
        }
    }
}

