/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.BlockData;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.FluidTankWrapper;
import mekanism.common.capabilities.merged.ChemicalTankWrapper;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.capabilities.proxy.ProxyChemicalHandler;
import mekanism.common.content.network.ChemicalNetwork;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.entity.EntityRobit;
import mekanism.common.integration.lookingat.ChemicalElement;
import mekanism.common.integration.lookingat.EnergyElement;
import mekanism.common.integration.lookingat.FluidElement;
import mekanism.common.integration.lookingat.LookingAtHelper;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookingAtUtils {
    public static final ResourceLocation ENERGY = Mekanism.rl("energy");
    public static final ResourceLocation FLUID = Mekanism.rl("fluid");
    public static final ResourceLocation CHEMICAL = Mekanism.rl("chemical");

    private LookingAtUtils() {
    }

    @Nullable
    private static MultiblockData getMultiblock(@Nullable BlockEntity tile) {
        if (tile instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)tile;
            return multiblock.getMultiblock();
        }
        if (tile instanceof IStructuralMultiblock) {
            IStructuralMultiblock multiblock = (IStructuralMultiblock)tile;
            for (Map.Entry<MultiblockManager<?>, Structure> entry : multiblock.getStructureMap().entrySet()) {
                Structure s;
                if (entry.getKey() == null || !(s = entry.getValue()).isValid()) continue;
                return s.getMultiblockData();
            }
        }
        return null;
    }

    public static void addInfo(LookingAtHelper info, @NotNull Entity entity) {
        if (entity instanceof EntityRobit) {
            EntityRobit robit = (EntityRobit)entity;
            LookingAtUtils.displayEnergy(info, robit);
        }
    }

    public static void addInfoOrRedirect(LookingAtHelper info, Level level, BlockPos pos, BlockState state, @Nullable BlockEntity tile, boolean displayTanks, boolean displayFluidTanks) {
        if (tile instanceof TileEntityBoundingBlock) {
            TileEntityBoundingBlock boundingBlock = (TileEntityBoundingBlock)tile;
            if (!boundingBlock.hasReceivedCoords() || pos.equals((Object)boundingBlock.getMainPos())) {
                return;
            }
            pos = boundingBlock.getMainPos();
            tile = WorldUtils.getTileEntity((BlockGetter)level, pos);
            if (tile == null) {
                return;
            }
            state = tile.getBlockState();
        }
        LookingAtUtils.addInfo(info, level, pos, state, tile, displayTanks, displayFluidTanks);
    }

    private static void addInfo(LookingAtHelper info, Level level, BlockPos pos, BlockState state, @Nullable BlockEntity tile, boolean displayTanks, boolean displayFluidTanks) {
        if (tile != null) {
            TileEntityQIORedstoneAdapter adapter;
            ItemStack itemType;
            TileEntityBin bin;
            BlockData blockData = (BlockData)tile.components().get((DataComponentType)MekanismDataComponents.BLOCK_DATA.value());
            if (blockData != null) {
                blockData.addToTooltip(info::addText);
            }
            if (tile instanceof TileEntityBin && (bin = (TileEntityBin)tile).getBinSlot().isLocked()) {
                info.addText((Component)MekanismLang.LOCKED.translateColored(EnumColor.AQUA, EnumColor.GRAY, bin.getBinSlot().getLockStack()));
            }
            if (tile instanceof TileEntityQIORedstoneAdapter && !(itemType = (adapter = (TileEntityQIORedstoneAdapter)tile).getItemType()).isEmpty()) {
                info.addText(itemType.getHoverName());
                MekanismLang match = adapter.isInverted() ? MekanismLang.GENERIC_LESS_THAN : MekanismLang.GENERIC_GREATER_EQUAL;
                info.addText((Component)match.translate(MekanismLang.QIO_TRIGGER_COUNT, TextUtils.format(adapter.getCount())));
                info.addText((Component)MekanismLang.QIO_FUZZY_MODE.translate(adapter.getFuzzyMode()));
            }
        }
        MultiblockData structure = LookingAtUtils.getMultiblock(tile);
        IStrictEnergyHandler energyCapability = (IStrictEnergyHandler)Capabilities.STRICT_ENERGY.getCapabilityIfLoaded(level, pos, state, tile, null);
        if (energyCapability != null) {
            LookingAtUtils.displayEnergy(info, energyCapability);
        } else if (structure != null && structure.isFormed()) {
            LookingAtUtils.displayEnergy(info, structure);
        }
        if (displayTanks) {
            if (displayFluidTanks && tile instanceof TileEntityUpdateable) {
                IFluidHandler fluidCapability = Capabilities.FLUID.getCapabilityIfLoaded(level, pos, state, tile, null);
                if (fluidCapability != null) {
                    TileEntityMechanicalPipe pipe;
                    FluidStack fallback = FluidStack.EMPTY;
                    if (tile instanceof TileEntityMechanicalPipe && (pipe = (TileEntityMechanicalPipe)tile).getTransmitter().hasTransmitterNetwork()) {
                        fallback = ((FluidNetwork)pipe.getTransmitter().getTransmitterNetwork()).lastFluid;
                    }
                    LookingAtUtils.displayFluid(info, fluidCapability, fallback);
                } else if (structure != null && structure.isFormed()) {
                    LookingAtUtils.displayFluid(info, structure, FluidStack.EMPTY);
                }
            }
            LookingAtUtils.addInfo(level, pos, state, tile, structure, info);
        }
    }

    private static void displayFluid(LookingAtHelper info, IFluidHandler fluidHandler, FluidStack fallback) {
        if (fluidHandler instanceof IMekanismFluidHandler) {
            IMekanismFluidHandler mekFluidHandler = (IMekanismFluidHandler)fluidHandler;
            for (IExtendedFluidTank fluidTank : mekFluidHandler.getFluidTanks(null)) {
                FluidTankWrapper wrapper;
                MergedTank mergedTank;
                MergedTank.CurrentType currentType;
                if (fluidTank instanceof FluidTankWrapper && (currentType = (mergedTank = (wrapper = (FluidTankWrapper)fluidTank).getMergedTank()).getCurrentType()) != MergedTank.CurrentType.EMPTY && currentType != MergedTank.CurrentType.FLUID) continue;
                LookingAtUtils.addFluidInfo(info, fluidTank.getFluid(), fluidTank.getCapacity(), fallback);
            }
        } else {
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                LookingAtUtils.addFluidInfo(info, fluidHandler.getFluidInTank(tank), fluidHandler.getTankCapacity(tank), fallback);
            }
        }
    }

    private static void addFluidInfo(LookingAtHelper info, FluidStack fluidInTank, int capacity, FluidStack fallback) {
        if (!fluidInTank.isEmpty()) {
            info.addText((Component)MekanismLang.LIQUID.translate(fluidInTank));
        } else if (!fallback.isEmpty()) {
            info.addText((Component)MekanismLang.LIQUID.translate(fallback));
        }
        info.addFluidElement(new FluidElement(fluidInTank, capacity));
    }

    private static void displayEnergy(LookingAtHelper info, IStrictEnergyHandler energyHandler) {
        int containers = energyHandler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            info.addEnergyElement(new EnergyElement(energyHandler.getEnergy(container), energyHandler.getMaxEnergy(container)));
        }
    }

    private static void addInfo(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity tile, @Nullable MultiblockData structure, LookingAtHelper info) {
        block10: {
            block9: {
                List<IChemicalTank> tanks;
                TileEntityPressurizedTube tube;
                IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapabilityIfLoaded(level, pos, state, tile, null);
                if (handler == null) break block9;
                Holder<Chemical> fallback = MekanismAPI.EMPTY_CHEMICAL_HOLDER;
                if (tile instanceof TileEntityPressurizedTube && (tube = (TileEntityPressurizedTube)tile).getTransmitter().hasTransmitterNetwork()) {
                    Iterator<IChemicalTank> network = (ChemicalNetwork)tube.getTransmitter().getTransmitterNetwork();
                    if (!((ChemicalNetwork)((Object)network)).lastChemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                        fallback = ((ChemicalNetwork)((Object)network)).lastChemical;
                    }
                }
                if (handler instanceof ProxyChemicalHandler && !(tanks = ((ProxyChemicalHandler)handler).getTanksIfMekanism()).isEmpty()) {
                    for (IChemicalTank tank : tanks) {
                        LookingAtUtils.addChemicalTankInfo(info, tank, fallback);
                    }
                    return;
                }
                if (handler instanceof IMekanismChemicalHandler) {
                    IMekanismChemicalHandler mekHandler = (IMekanismChemicalHandler)handler;
                    for (IChemicalTank tank : mekHandler.getChemicalTanks(null)) {
                        LookingAtUtils.addChemicalTankInfo(info, tank, fallback);
                    }
                } else {
                    for (int i = 0; i < handler.getChemicalTanks(); ++i) {
                        LookingAtUtils.addChemicalInfo(info, handler.getChemicalInTank(i), handler.getChemicalTankCapacity(i), fallback);
                    }
                }
                break block10;
            }
            if (structure == null || !structure.isFormed()) break block10;
            for (IChemicalTank tank : structure.getChemicalTanks(null)) {
                LookingAtUtils.addChemicalTankInfo(info, tank, MekanismAPI.EMPTY_CHEMICAL_HOLDER);
            }
        }
    }

    private static void addChemicalTankInfo(LookingAtHelper info, IChemicalTank chemicalTank, Holder<Chemical> fallback) {
        ChemicalTankWrapper tankWrapper;
        MergedTank tank;
        if (chemicalTank instanceof ChemicalTankWrapper && (tank = (tankWrapper = (ChemicalTankWrapper)chemicalTank).getMergedTank()).getCurrentType() != MergedTank.CurrentType.CHEMICAL) {
            return;
        }
        LookingAtUtils.addChemicalInfo(info, chemicalTank.getStack(), chemicalTank.getCapacity(), fallback);
    }

    private static void addChemicalInfo(LookingAtHelper info, ChemicalStack chemicalInTank, long capacity, Holder<Chemical> fallback) {
        if (!chemicalInTank.isEmpty()) {
            info.addText((Component)MekanismLang.CHEMICAL.translate(chemicalInTank));
        } else if (!fallback.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
            info.addText((Component)MekanismLang.CHEMICAL.translate(fallback));
        }
        info.addChemicalElement(new ChemicalElement(chemicalInTank, capacity));
    }
}

