/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.BitSet;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.MinerRegionCache;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class ThreadMinerSearch
extends Thread {
    private final TileEntityDigitalMiner tile;
    private final Long2ObjectMap<BitSet> oresToMine = new Long2ObjectOpenHashMap();
    private MinerRegionCache chunkCache;
    public State state = State.IDLE;
    public int found = 0;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        super("Digital Miner Search thread " + String.valueOf(tile.getBlockPos()));
        this.tile = tile;
        this.setDaemon(true);
    }

    public void setChunkCache(MinerRegionCache cache) {
        this.chunkCache = cache;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        if (!this.tile.getInverse() && !this.tile.getFilterManager().hasEnabledFilters()) {
            this.state = State.FINISHED;
            return;
        }
        Reference2BooleanOpenHashMap acceptedItems = new Reference2BooleanOpenHashMap();
        BlockPos pos = this.tile.getStartingPos();
        int diameter = this.tile.getDiameter();
        int size = this.tile.getTotalSize();
        BlockPos minerPos = this.tile.getBlockPos();
        for (int i = 0; i < size; ++i) {
            boolean accepted;
            Block info;
            BlockState state;
            if (this.tile.isRemoved() || this.isInterrupted()) {
                return;
            }
            BlockPos testPos = TileEntityDigitalMiner.getOffsetForIndex(pos, diameter, i);
            if (minerPos.equals((Object)testPos) || WorldUtils.getTileEntity(TileEntityBoundingBlock.class, this.chunkCache, testPos) != null || (state = this.chunkCache.getBlockState(testPos)).isAir() || state.is(MekanismTags.Blocks.MINER_BLACKLIST) || this.shouldSkipState(state) || state.getDestroySpeed((BlockGetter)this.chunkCache, testPos) < 0.0f || MekanismUtils.isLiquidBlock(info = state.getBlock())) continue;
            if (acceptedItems.containsKey((Object)info)) {
                accepted = acceptedItems.getBoolean((Object)info);
            } else {
                accepted = this.tile.isReplaceTarget(info.asItem()) ? false : this.tile.getInverse() != this.tile.getFilterManager().anyEnabledMatch(state, MinerFilter::canFilter);
                acceptedItems.put((Object)info, accepted);
            }
            if (!accepted) continue;
            long chunk = ChunkPos.asLong((BlockPos)testPos);
            ((BitSet)this.oresToMine.computeIfAbsent(chunk, k -> new BitSet())).set(i);
            ++this.found;
        }
        this.state = State.FINISHED;
        this.chunkCache = null;
        if (ThreadMinerSearch.interrupted()) {
            return;
        }
        if (this.tile.searcher == this) {
            this.tile.updateFromSearch(this.oresToMine, this.found);
        }
    }

    private boolean shouldSkipState(BlockState state) {
        if (state.getBlock() instanceof BedBlock) {
            return state.getValue((Property)BlockStateProperties.BED_PART) == BedPart.FOOT;
        }
        if (state.getBlock() instanceof DoorBlock || state.getBlock() instanceof DoublePlantBlock) {
            return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER;
        }
        return false;
    }

    @NothingNullByDefault
    public static enum State implements IHasTextComponent.IHasEnumNameTextComponent
    {
        IDLE(MekanismLang.MINER_IDLE),
        SEARCHING(MekanismLang.MINER_SEARCHING),
        PAUSED(MekanismLang.MINER_PAUSED),
        FINISHED(MekanismLang.MINER_READY);

        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;
        private final ILangEntry langEntry;

        private State(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate();
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])State.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

